% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_helpers.R
\name{interval_labels}
\alias{interval_labels}
\title{Convenience functions for interval recodes}
\usage{
interval_labels(from, to, width = 5)
}
\arguments{
\item{from, to}{A \code{numeric value} for the beginning and the end of the interval.}

\item{width}{The width of the interval, e.g. 5 (default) for intervals 0-5.}
}
\value{
A \code{character} vector of interval labels compatible with \link{cut}
}
\description{
Get interval labels for even intervals of discrete numeric values compatible
with \link{cut}.
}
\examples{
\dontrun{
x       <- round(runif(100, 0, 100), 0)
labels  <- interval_labels(0, 100, 10)

cut(x, breaks = seq(0, 100, 10), labels = labels)
}
}

