% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_fonts.R
\name{fonts_as_import}
\alias{fonts_as_import}
\title{Create import specifications for web content}
\usage{
fonts_as_import(
  family,
  italic = NULL,
  weight = NULL,
  width = NULL,
  ...,
  type = c("url", "import", "link"),
  may_embed = TRUE,
  repositories = c("Google Fonts", "Font Library")
)
}
\arguments{
\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{...}{Additional arguments passed on to the specific functions for the
repositories. Currently:
\itemize{
\item \strong{Google Fonts:}
\itemize{
\item \code{text} A piece of text containing the glyphs required. Using this can
severely cut down on the size of the required download
\item \code{display} One of \code{"auto"}, \code{"block"}, \code{"swap"}, \code{"fallback"}, or
\code{"optional"}. Controls how the text is displayed while the font is
downloading.
}
}}

\item{type}{The type of return value. \code{"url"} returns the bare url pointing
to the style sheet. \code{"import"} returns the stylesheet as an import statement
(\verb{@import url(<url>)}). \code{"link"} returns the stylesheet as a link tag
(\verb{<link rel="stylesheet" href="<url>"/>})}

\item{may_embed}{Logical. Should fonts that can't be found in the provided
repositories be embedded as data-URLs. This is only possible if the font is
available locally and in a \code{woff2}, \code{woff}, \code{otf}, or \code{ttf} file.}

\item{repositories}{The repositories to try looking for the font. Currently
\code{"Google Fonts"} and \code{"Font Library"} are supported. Set this to \code{NULL}
together with \code{may_embed = TRUE} to force embedding of the font data.}
}
\value{
A character vector with stylesheet specifications according to \code{type}
}
\description{
If you create content in a text-based format such as HTML or SVG you need to
make sure that the font is available on the computer where it is viewed. This
can be achieved through the use of stylesheets that can either be added with
a \verb{<link>} tag or inserted with an \verb{@import} statement. This function
facilitates the creation of either of these (or the bare URL to the
stylesheet). It can rely on the Google Fonts or Font Library repository for
serving the fonts. If the requested font is not found it can optionally hard
code the data into the stylesheet.
}
