% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reshape_data.R
\name{ReshapeData}
\alias{ReshapeData}
\title{Transform the response data from the data frame format to dose-response matrixes}
\usage{
ReshapeData(data, data.type = "viability")
}
\arguments{
\item{data}{drug combination response data in a data frame format}

\item{data.type}{a parameter to specify the response data type which can be either "viability" or "inhibition".}
}
\value{
a list of the following components:
\item{dose.response.mats}{a list of the dose-response matrixes with \%inhibition as the response data. Row names and column names are drug concentrations.}
\item{drug.pairs}{a data frame contains the name of the row drug, the name of the column drug, concentration unit and block IDs.}
}
\description{
A function to transform the response data from the data frame format to dose-response matrixes
}
\details{
The input data must contain the following columns: BlockID, DrugRow, DrugCol, Row, Col, Response,
ConcRow, ConcCol, ConcUnit
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

