% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{simdat}
\alias{simdat}
\title{Simulate data with varying degrees of selection and confounding bias}
\usage{
simdat(
  N,
  X_dist = "continuous",
  S_known = FALSE,
  tau_0 = 0,
  tau_X = 1,
  beta_0 = 0,
  beta_A = 1,
  beta_X = 1,
  hetero = TRUE,
  alpha_0 = 0,
  alpha_X = 1,
  alpha_A = 1,
  alpha_AX = 0.1
)
}
\arguments{
\item{N}{int - Number of observations to be generated}

\item{X_dist}{string - Distribution of the confounding variable, X. Defaults
to "continuous" for a N(1, 1) variable, or "binary" for a Bernoulli(0.5)
variable}

\item{S_known}{boolean - Logical for whether the selection mechanism should
be treated as known (deterministic) or needs to be estimated (simulated with
Gaussian error; defaults to FALSE)}

\item{tau_0}{double - Intercept for propensity model (defaults to 0)}

\item{tau_X}{double - Coefficient for X in propensity model (defaults to 1)}

\item{beta_0}{double - Intercept for selection model (defaults to 0)}

\item{beta_A}{double - Coefficient for A in selection model (defaults to 1)}

\item{beta_X}{double - Coefficient for X in selection model (defaults to 1)}

\item{hetero}{boolean - Logical for heterogeneous treatment effect in
the outcome model (defaults to TRUE)}

\item{alpha_0}{double - Intercept for outcome model (defaults to 0)}

\item{alpha_X}{double - Coefficient for X in outcome model (defaults to 1)}

\item{alpha_A}{double - Coefficient for A in outcome model (defaults to 1)}

\item{alpha_AX}{double - Coefficient for interaction between A and X in
outcome model (only used if \code{hetero == TRUE}; defaults to 0.1)}
}
\value{
A \code{data.frame} with \code{N} observations of 7 variables:
\describe{
   \item{Y}{Observed outcome (continuous)}
   \item{A}{Comparison group variable of interest (binary)}
   \item{X}{Confounding variable (continuous or binary)}
   \item{P_A_cond_X}{True probability of A = 1 conditional on X (continuous)}
   \item{P_S_cond_AX}{True probability of selection (S = 1) conditional on A and X (continuous)}
   \item{P_S_cond_A1X}{True probability of selection (S = 1) conditional on A = 1 and X (continuous)}
   \item{P_S_cond_A0X}{True probability of selection (S = 1) conditional on A = 0 and X (continuous)}
   \item{CDIFF}{True controlled difference in outcomes by comparison group (double)}
}
}
\description{
Function to simulate data based on specified relationships between the
generated (continuous) outcome, variable of interest, confounder, and
selection mechanism.
}
\details{
The data are generated as follows. For a user-given number, \code{N},
observations in our so-called super population, we first generate a
confounding variable, \code{X}, which relates to our outcome, \code{Y}, our
variable of interest, \code{A}, and our selection indicator, \code{S}.
We generate population-level data with \code{X ~ N(1,1)} or
\code{X ~ Bern(0.5)} depending on whether distribution of \code{X} is
chosen to be \code{X_dist = "continous"} or \code{X_dist = "binary"},
respectively.

We then generate the remaining data from three models:

\describe{
   \item{1. Propensity Model}{}
   \item{2. Selection Model}{}
   \item{3. Outcome Model}{}
}
}
\examples{

N <- 100000

dat <- simdat(N)

head(dat)

}
