/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.DecisionStump;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class LogitBoost
extends RandomizableIteratedSingleClassifierEnhancer
implements Sourcable,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3905660358715833753L;
    protected Classifier[][] m_Classifiers;
    protected int m_NumClasses;
    protected int m_NumGenerated;
    protected int m_NumFolds = 0;
    protected int m_NumRuns = 1;
    protected int m_WeightThreshold = 100;
    protected static final double Z_MAX = 3.0;
    protected Instances m_NumericClassData;
    protected Attribute m_ClassAttribute;
    protected boolean m_UseResampling;
    protected double m_Precision = -1.7976931348623157E308;
    protected double m_Shrinkage = 1.0;
    protected Random m_RandomInstance = null;
    protected double m_Offset = 0.0;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for performing additive logistic regression. \nThis class performs classification using a regression scheme as the base learner, and can handle multi-class problems.  For more information, see\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "Can do efficient internal cross-validation to determine " + "appropriate number of iterations.";
    }

    public LogitBoost() {
        this.m_Classifier = new DecisionStump();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Friedman and T. Hastie and R. Tibshirani");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Additive Logistic Regression: a Statistical View of Boosting");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Stanford University");
        result.setValue(TechnicalInformation.Field.PS, "http://www-stat.stanford.edu/~jhf/ftp/boost.ps");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.DecisionStump";
    }

    protected Instances selectWeightQuantile(Instances data, double quantile) {
        int numInstances = data.numInstances();
        Instances trainData = new Instances(data, numInstances);
        double[] weights = new double[numInstances];
        double sumOfWeights = 0.0;
        for (int i = 0; i < numInstances; ++i) {
            weights[i] = data.instance(i).weight();
            sumOfWeights += weights[i];
        }
        double weightMassToSelect = sumOfWeights * quantile;
        int[] sortedIndices = Utils.sort(weights);
        sumOfWeights = 0.0;
        for (int i = numInstances - 1; i >= 0; --i) {
            Instance instance = (Instance)data.instance(sortedIndices[i]).copy();
            trainData.add(instance);
            if ((sumOfWeights += weights[sortedIndices[i]]) > weightMassToSelect && i > 0 && weights[sortedIndices[i]] != weights[sortedIndices[i - 1]]) break;
        }
        if (this.m_Debug) {
            System.err.println("Selected " + trainData.numInstances() + " out of " + numInstances);
        }
        return trainData;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tUse resampling instead of reweighting for boosting.", "Q", 0, "-Q"));
        newVector.addElement(new Option("\tPercentage of weight mass to base training on.\n\t(default 100, reduce to around 90 speed up)", "P", 1, "-P <percent>"));
        newVector.addElement(new Option("\tNumber of folds for internal cross-validation.\n\t(default 0 -- no cross-validation)", "F", 1, "-F <num>"));
        newVector.addElement(new Option("\tNumber of runs for internal cross-validation.\n\t(default 1)", "R", 1, "-R <num>"));
        newVector.addElement(new Option("\tThreshold on the improvement of the likelihood.\n\t(default -Double.MAX_VALUE)", "L", 1, "-L <num>"));
        newVector.addElement(new Option("\tShrinkage parameter.\n\t(default 1)", "H", 1, "-H <num>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFolds = Utils.getOption('F', options);
        if (numFolds.length() != 0) {
            this.setNumFolds(Integer.parseInt(numFolds));
        } else {
            this.setNumFolds(0);
        }
        String numRuns = Utils.getOption('R', options);
        if (numRuns.length() != 0) {
            this.setNumRuns(Integer.parseInt(numRuns));
        } else {
            this.setNumRuns(1);
        }
        String thresholdString = Utils.getOption('P', options);
        if (thresholdString.length() != 0) {
            this.setWeightThreshold(Integer.parseInt(thresholdString));
        } else {
            this.setWeightThreshold(100);
        }
        String precisionString = Utils.getOption('L', options);
        if (precisionString.length() != 0) {
            this.setLikelihoodThreshold(new Double(precisionString));
        } else {
            this.setLikelihoodThreshold(-1.7976931348623157E308);
        }
        String shrinkageString = Utils.getOption('H', options);
        if (shrinkageString.length() != 0) {
            this.setShrinkage(new Double(shrinkageString));
        } else {
            this.setShrinkage(1.0);
        }
        this.setUseResampling(Utils.getFlag('Q', options));
        if (this.m_UseResampling && thresholdString.length() != 0) {
            throw new Exception("Weight pruning with resamplingnot allowed.");
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 10];
        int current = 0;
        if (this.getUseResampling()) {
            options[current++] = "-Q";
        } else {
            options[current++] = "-P";
            options[current++] = "" + this.getWeightThreshold();
        }
        options[current++] = "-F";
        options[current++] = "" + this.getNumFolds();
        options[current++] = "-R";
        options[current++] = "" + this.getNumRuns();
        options[current++] = "-L";
        options[current++] = "" + this.getLikelihoodThreshold();
        options[current++] = "-H";
        options[current++] = "" + this.getShrinkage();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String shrinkageTipText() {
        return "Shrinkage parameter (use small value like 0.1 to reduce overfitting).";
    }

    public double getShrinkage() {
        return this.m_Shrinkage;
    }

    public void setShrinkage(double newShrinkage) {
        this.m_Shrinkage = newShrinkage;
    }

    public String likelihoodThresholdTipText() {
        return "Threshold on improvement in likelihood.";
    }

    public double getLikelihoodThreshold() {
        return this.m_Precision;
    }

    public void setLikelihoodThreshold(double newPrecision) {
        this.m_Precision = newPrecision;
    }

    public String numRunsTipText() {
        return "Number of runs for internal cross-validation.";
    }

    public int getNumRuns() {
        return this.m_NumRuns;
    }

    public void setNumRuns(int newNumRuns) {
        this.m_NumRuns = newNumRuns;
    }

    public String numFoldsTipText() {
        return "Number of folds for internal cross-validation (default 0 means no cross-validation is performed).";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int newNumFolds) {
        this.m_NumFolds = newNumFolds;
    }

    public String useResamplingTipText() {
        return "Whether resampling is used instead of reweighting.";
    }

    public void setUseResampling(boolean r) {
        this.m_UseResampling = r;
    }

    public boolean getUseResampling() {
        return this.m_UseResampling;
    }

    public String weightThresholdTipText() {
        return "Weight threshold for weight pruning (reduce to 90 for speeding up learning process).";
    }

    public void setWeightThreshold(int threshold) {
        this.m_WeightThreshold = threshold;
    }

    public int getWeightThreshold() {
        return this.m_WeightThreshold;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int j;
        this.m_RandomInstance = new Random(this.m_Seed);
        int classIndex = data.classIndex();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (!(this.m_Classifier instanceof WeightedInstancesHandler) && !this.m_UseResampling) {
            this.m_UseResampling = true;
        }
        this.getCapabilities().testWithFail(data);
        if (this.m_Debug) {
            System.err.println("Creating copy of the training data");
        }
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(data);
            return;
        }
        this.m_ZeroR = null;
        this.m_NumClasses = data.numClasses();
        this.m_ClassAttribute = data.classAttribute();
        if (this.m_Debug) {
            System.err.println("Creating base classifiers");
        }
        this.m_Classifiers = new Classifier[this.m_NumClasses][];
        for (int j2 = 0; j2 < this.m_NumClasses; ++j2) {
            this.m_Classifiers[j2] = AbstractClassifier.makeCopies(this.m_Classifier, this.getNumIterations());
        }
        int bestNumIterations = this.getNumIterations();
        if (this.m_NumFolds > 1) {
            if (this.m_Debug) {
                System.err.println("Processing first fold.");
            }
            double[] results = new double[this.getNumIterations()];
            for (int r = 0; r < this.m_NumRuns; ++r) {
                data.randomize(this.m_RandomInstance);
                data.stratify(this.m_NumFolds);
                for (int i = 0; i < this.m_NumFolds; ++i) {
                    Instances train = data.trainCV(this.m_NumFolds, i, this.m_RandomInstance);
                    Instances test = data.testCV(this.m_NumFolds, i);
                    Instances trainN = new Instances(train);
                    trainN.setClassIndex(-1);
                    trainN.deleteAttributeAt(classIndex);
                    trainN.insertAttributeAt(new Attribute("'pseudo class'"), classIndex);
                    trainN.setClassIndex(classIndex);
                    this.m_NumericClassData = new Instances(trainN, 0);
                    int numInstances = train.numInstances();
                    double[][] trainFs = new double[numInstances][this.m_NumClasses];
                    double[][] trainYs = new double[numInstances][this.m_NumClasses];
                    for (int j3 = 0; j3 < this.m_NumClasses; ++j3) {
                        for (int k = 0; k < numInstances; ++k) {
                            trainYs[k][j3] = train.instance(k).classValue() == (double)j3 ? 1.0 - this.m_Offset : 0.0 + this.m_Offset / (double)this.m_NumClasses;
                        }
                    }
                    double[][] probs = this.initialProbs(numInstances);
                    this.m_NumGenerated = 0;
                    double sumOfWeights = train.sumOfWeights();
                    int j4 = 0;
                    while (j4 < this.getNumIterations()) {
                        this.performIteration(trainYs, trainFs, probs, trainN, sumOfWeights);
                        Evaluation eval = new Evaluation(train);
                        eval.evaluateModel(this, test, new Object[0]);
                        int n = j4++;
                        results[n] = results[n] + eval.correct();
                    }
                }
            }
            double bestResult = -1.7976931348623157E308;
            for (j = 0; j < this.getNumIterations(); ++j) {
                if (!(results[j] > bestResult)) continue;
                bestResult = results[j];
                bestNumIterations = j;
            }
            if (this.m_Debug) {
                System.err.println("Best result for " + bestNumIterations + " iterations: " + bestResult);
            }
        }
        int numInstances = data.numInstances();
        double[][] trainFs = new double[numInstances][this.m_NumClasses];
        double[][] trainYs = new double[numInstances][this.m_NumClasses];
        for (j = 0; j < this.m_NumClasses; ++j) {
            int i = 0;
            int k = 0;
            while (i < numInstances) {
                trainYs[i][j] = data.instance(k).classValue() == (double)j ? 1.0 - this.m_Offset : 0.0 + this.m_Offset / (double)this.m_NumClasses;
                ++i;
                ++k;
            }
        }
        data.setClassIndex(-1);
        data.deleteAttributeAt(classIndex);
        data.insertAttributeAt(new Attribute("'pseudo class'"), classIndex);
        data.setClassIndex(classIndex);
        this.m_NumericClassData = new Instances(data, 0);
        double[][] probs = this.initialProbs(numInstances);
        double logLikelihood = this.logLikelihood(trainYs, probs);
        this.m_NumGenerated = 0;
        if (this.m_Debug) {
            System.err.println("Avg. log-likelihood: " + logLikelihood);
        }
        double sumOfWeights = data.sumOfWeights();
        for (int j5 = 0; j5 < bestNumIterations; ++j5) {
            double previousLoglikelihood = logLikelihood;
            this.performIteration(trainYs, trainFs, probs, data, sumOfWeights);
            logLikelihood = this.logLikelihood(trainYs, probs);
            if (this.m_Debug) {
                System.err.println("Avg. log-likelihood: " + logLikelihood);
            }
            if (!(Math.abs(previousLoglikelihood - logLikelihood) < this.m_Precision)) continue;
            return;
        }
    }

    private double[][] initialProbs(int numInstances) {
        double[][] probs = new double[numInstances][this.m_NumClasses];
        for (int i = 0; i < numInstances; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                probs[i][j] = 1.0 / (double)this.m_NumClasses;
            }
        }
        return probs;
    }

    private double logLikelihood(double[][] trainYs, double[][] probs) {
        double logLikelihood = 0.0;
        for (int i = 0; i < trainYs.length; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (trainYs[i][j] != 1.0 - this.m_Offset) continue;
                logLikelihood -= Math.log(probs[i][j]);
            }
        }
        return logLikelihood / (double)trainYs.length;
    }

    private void performIteration(double[][] trainYs, double[][] trainFs, double[][] probs, Instances data, double origSumOfWeights) throws Exception {
        int i;
        if (this.m_Debug) {
            System.err.println("Training classifier " + (this.m_NumGenerated + 1));
        }
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (this.m_Debug) {
                System.err.println("\t...for class " + (j + 1) + " (" + this.m_ClassAttribute.name() + "=" + this.m_ClassAttribute.value(j) + ")");
            }
            Instances boostData = new Instances(data);
            for (int i2 = 0; i2 < probs.length; ++i2) {
                double z;
                double p = probs[i2][j];
                double actual = trainYs[i2][j];
                if (actual == 1.0 - this.m_Offset) {
                    z = 1.0 / p;
                    if (z > 3.0) {
                        z = 3.0;
                    }
                } else {
                    z = -1.0 / (1.0 - p);
                    if (z < -3.0) {
                        z = -3.0;
                    }
                }
                double w = (actual - p) / z;
                Instance current = boostData.instance(i2);
                current.setValue(boostData.classIndex(), z);
                current.setWeight(current.weight() * w);
            }
            double sumOfWeights = boostData.sumOfWeights();
            double scalingFactor = origSumOfWeights / sumOfWeights;
            for (int i3 = 0; i3 < probs.length; ++i3) {
                Instance current = boostData.instance(i3);
                current.setWeight(current.weight() * scalingFactor);
            }
            Instances trainData = boostData;
            if (this.m_WeightThreshold < 100) {
                trainData = this.selectWeightQuantile(boostData, (double)this.m_WeightThreshold / 100.0);
            } else if (this.m_UseResampling) {
                double[] weights = new double[boostData.numInstances()];
                for (int kk = 0; kk < weights.length; ++kk) {
                    weights[kk] = boostData.instance(kk).weight();
                }
                trainData = boostData.resampleWithWeights(this.m_RandomInstance, weights);
            }
            this.m_Classifiers[j][this.m_NumGenerated].buildClassifier(trainData);
        }
        for (i = 0; i < trainFs.length; ++i) {
            int j;
            double[] pred = new double[this.m_NumClasses];
            double predSum = 0.0;
            for (j = 0; j < this.m_NumClasses; ++j) {
                pred[j] = this.m_Shrinkage * this.m_Classifiers[j][this.m_NumGenerated].classifyInstance(data.instance(i));
                predSum += pred[j];
            }
            predSum /= (double)this.m_NumClasses;
            for (j = 0; j < this.m_NumClasses; ++j) {
                double[] dArray = trainFs[i];
                int n = j;
                dArray[n] = dArray[n] + (pred[j] - predSum) * (double)(this.m_NumClasses - 1) / (double)this.m_NumClasses;
            }
        }
        ++this.m_NumGenerated;
        for (i = 0; i < trainYs.length; ++i) {
            probs[i] = this.probs(trainFs[i]);
        }
    }

    public Classifier[][] classifiers() {
        Classifier[][] classifiers = new Classifier[this.m_NumClasses][this.m_NumGenerated];
        for (int j = 0; j < this.m_NumClasses; ++j) {
            for (int i = 0; i < this.m_NumGenerated; ++i) {
                classifiers[j][i] = this.m_Classifiers[j][i];
            }
        }
        return classifiers;
    }

    private double[] probs(double[] Fs) {
        double maxF = -1.7976931348623157E308;
        for (int i = 0; i < Fs.length; ++i) {
            if (!(Fs[i] > maxF)) continue;
            maxF = Fs[i];
        }
        double sum = 0.0;
        double[] probs = new double[Fs.length];
        for (int i = 0; i < Fs.length; ++i) {
            probs[i] = Math.exp(Fs[i] - maxF);
            sum += probs[i];
        }
        Utils.normalize(probs, sum);
        return probs;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        instance = (Instance)instance.copy();
        instance.setDataset(this.m_NumericClassData);
        double[] pred = new double[this.m_NumClasses];
        double[] Fs = new double[this.m_NumClasses];
        for (int i = 0; i < this.m_NumGenerated; ++i) {
            int j;
            double predSum = 0.0;
            for (j = 0; j < this.m_NumClasses; ++j) {
                pred[j] = this.m_Shrinkage * this.m_Classifiers[j][i].classifyInstance(instance);
                predSum += pred[j];
            }
            predSum /= (double)this.m_NumClasses;
            for (j = 0; j < this.m_NumClasses; ++j) {
                int n = j;
                Fs[n] = Fs[n] + (pred[j] - predSum) * (double)(this.m_NumClasses - 1) / (double)this.m_NumClasses;
            }
        }
        return this.probs(Fs);
    }

    @Override
    public String toSource(String className) throws Exception {
        int j;
        int i;
        if (this.m_NumGenerated == 0) {
            throw new Exception("No model built yet");
        }
        if (!(this.m_Classifiers[0][0] instanceof Sourcable)) {
            throw new Exception("Base learner " + this.m_Classifier.getClass().getName() + " is not Sourcable");
        }
        StringBuffer text = new StringBuffer("class ");
        text.append(className).append(" {\n\n");
        text.append("  private static double RtoP(double []R, int j) {\n    double Rcenter = 0;\n    for (int i = 0; i < R.length; i++) {\n      Rcenter += R[i];\n    }\n    Rcenter /= R.length;\n    double Rsum = 0;\n    for (int i = 0; i < R.length; i++) {\n      Rsum += Math.exp(R[i] - Rcenter);\n    }\n    return Math.exp(R[j]) / Rsum;\n  }\n\n");
        text.append("  public static double classify(Object[] i) {\n    double [] d = distribution(i);\n    double maxV = d[0];\n    int maxI = 0;\n    for (int j = 1; j < " + this.m_NumClasses + "; j++) {\n" + "      if (d[j] > maxV) { maxV = d[j]; maxI = j; }\n" + "    }\n    return (double) maxI;\n  }\n\n");
        text.append("  public static double [] distribution(Object [] i) {\n");
        text.append("    double [] Fs = new double [" + this.m_NumClasses + "];\n");
        text.append("    double [] Fi = new double [" + this.m_NumClasses + "];\n");
        text.append("    double Fsum;\n");
        for (i = 0; i < this.m_NumGenerated; ++i) {
            text.append("    Fsum = 0;\n");
            for (j = 0; j < this.m_NumClasses; ++j) {
                text.append("    Fi[" + j + "] = " + className + '_' + j + '_' + i + ".classify(i); Fsum += Fi[" + j + "];\n");
            }
            text.append("    Fsum /= " + this.m_NumClasses + ";\n");
            text.append("    for (int j = 0; j < " + this.m_NumClasses + "; j++) {");
            text.append(" Fs[j] += (Fi[j] - Fsum) * " + (this.m_NumClasses - 1) + " / " + this.m_NumClasses + "; }\n");
        }
        text.append("    double [] dist = new double [" + this.m_NumClasses + "];\n" + "    for (int j = 0; j < " + this.m_NumClasses + "; j++) {\n" + "      dist[j] = RtoP(Fs, j);\n" + "    }\n    return dist;\n");
        text.append("  }\n}\n");
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            for (j = 0; j < this.m_Classifiers[i].length; ++j) {
                text.append(((Sourcable)((Object)this.m_Classifiers[i][j])).toSource(className + '_' + i + '_' + j));
            }
        }
        return text.toString();
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        StringBuffer text = new StringBuffer();
        if (this.m_NumGenerated == 0) {
            text.append("LogitBoost: No model built yet.");
        } else {
            text.append("LogitBoost: Base classifiers and their weights: \n");
            for (int i = 0; i < this.m_NumGenerated; ++i) {
                text.append("\nIteration " + (i + 1));
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    text.append("\n\tClass " + (j + 1) + " (" + this.m_ClassAttribute.name() + "=" + this.m_ClassAttribute.value(j) + ")\n\n" + this.m_Classifiers[j][i].toString() + "\n");
                }
            }
            text.append("Number of performed iterations: " + this.m_NumGenerated + "\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6091 $");
    }

    public static void main(String[] argv) {
        LogitBoost.runClassifier(new LogitBoost(), argv);
    }
}

