% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R
\name{make_fm_plot}
\alias{make_fm_plot}
\title{Make Fisher-Mill plot}
\usage{
make_fm_plot(x, propensity, s, jitter_prognosis, jitter_propensity)
}
\arguments{
\item{x}{a \code{strata} object returned by \code{\link{auto_stratify}} or
\code{\link{manual_stratify}}}

\item{propensity}{ignored unless \code{type = "hist"} or \code{type = "FM"}.
Specifies propensity score information for plots where this is required.
Accepts either a vector of propensity scores, a \code{glm} model for
propensity scores, or a formula for fitting a propensity score model.}

\item{s}{the number code of the stratum to be plotted}

\item{jitter_prognosis}{ignored unless \code{type = "FM"}.  Amount of uniform
random noise to add to prognostic scores in plot.}

\item{jitter_propensity}{ignored unless \code{type = "FM"}.  Amount of
uniform random noise to add to propensity scores in plot.}
}
\description{
Not meant to be called externally.  Helper plot function for \code{strata}
object with \code{type = "FM"}. Produces a Fisher-Mill plot of stratum \code{s}
}
\seealso{
Aikens et al. (preprint) \url{https://arxiv.org/abs/1908.09077} .
  Section 3.2 for an explaination of Fisher-Mill plots
}
\keyword{internal}
