% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.bayes.prop1}
\alias{ci.bayes.prop1}
\title{Bayesian credible interval for a single proportion}
\usage{
ci.bayes.prop1(alpha, prior.mean, prior.sd, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior.mean}{mean of prior Beta distribution}

\item{prior.sd}{standard deviation of prior Beta distribution}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean of Beta distributoin
\item Posterior SD - posterior standard deviation of Beta distributoin
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes a Bayesian credible interval for a single proportion using the
mean and standard deviation of a prior Beta distribution along with sample
information. The mean and standard deviation of the posterior Beta
distribution are also reported. For a noninformative prior, set the prior
mean to .5 and the prior standard deviation to 1/sqrt(12) (which
corresponds to a Beta(1,1) distribution). The prior variance must be
less than m(1 - m) where m is the prior mean.
}
\examples{
ci.bayes.prop1(.05, .4, .1, 12, 100)

# Should return:
# Posterior mean Posterior SD       LL        UL
#           0.15   0.03273268  0.09218 0.2188484


}
\references{
\insertRef{Gelman2004}{statpsych}
}
