% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.mean.ps}
\alias{ci.ratio.mean.ps}
\title{Confidence interval for a paired-samples mean ratio}
\usage{
ci.ratio.mean.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of measurement 1 scores}

\item{y2}{vector of measurement 2 scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Mean1 - estimated measurement 1 mean
\item Mean2 - estimated measurement 2 mean
\item Mean1/Mean2 - estimate of mean ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Compute a confidence interval for a ratio of population means of
ratio-scale measurements in a paired-samples design. Equality of
variances is not assumed.
}
\examples{
y1 <- c(3.3, 3.6, 3.0, 3.1, 3.9, 4.2, 3.5, 3.3)
y2 <- c(3.0, 3.1, 2.7, 2.6, 3.2, 3.8, 3.2, 3.0)
ci.ratio.mean.ps(.05, y1, y2)

# Should return:
#       Mean1 Mean2 Mean1/Mean2      LL       UL
# [1,] 3.4875 3.075    1.134146 1.09417 1.175583


}
\references{
\insertRef{Bonett2020b}{statpsych}
}
