% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{test.skew}
\alias{test.skew}
\title{Computes p-value for test of skewness}
\usage{
test.skew(y)
}
\arguments{
\item{y}{vector of quantitative scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Skewness - Estimate of skewness coefficient
\item p - Monte Carlo two-sided p-value for test of zero skewness
}
}
\description{
Computes a Monte Carlo p-value (250,000 replications) for the null
hypothesis that the sample data come from a normal distribution. If the
p-value is small (e.g., less than .05) and the skewness estimate is
positive, then the normality assumption can be rejected due to positive
skewness. If the p-value is small (e.g., less than .05) and the skewness
estimate is negative, then the normality assumption can be rejected due
to negative skewness.
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40, 95)
test.skew(y)

# Should return:
#      Skewness      p
# [1,]   1.5201 0.0067


}
