% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{sp_get_dataset}
\alias{sp_get_dataset}
\title{Retrieve dataset from statnipokladna}
\usage{
sp_get_dataset(
  dataset_id,
  year = 2018,
  month = 12,
  dest_dir = tempdir(),
  redownload = FALSE
)
}
\arguments{
\item{dataset_id}{A dataset ID. See \code{id} column in \code{sp_datasets} for a list of available codelists.}

\item{year}{year, numeric, 2015-2018 for some datasets, 2010-2019 for others. Defaults to 2018.}

\item{month}{month, numeric. Must be between 1 and 12. Defaults to 12.}

\item{dest_dir}{character. Directory in which downloaded files will be stored. Defaults to \code{tempdir()}. Will be created if it does not exist.}

\item{redownload}{Redownload even if file has already been downloaded? Defaults to FALSE.}
}
\value{
character string with complete paths to downloaded files.
}
\description{
Downloads and unzips files for a given dataset.
}
\details{
Files are stored in a temp folder as determined by \code{tempdir()} and further sorted into
subdirectories by dataset, year and month. They persist per session to avoid redownloads.
}
\examples{
\donttest{
budget_latest <- sp_get_dataset("finm")
budget_2018 <- sp_get_dataset("finm", 2018)
budget_mid2018 <- sp_get_dataset("finm", 2018, 6)
}
}
\seealso{
Other Core workflow: 
\code{\link{add_codelist}()},
\code{\link{get_codelist}()},
\code{\link{sp_add_codelist}()},
\code{\link{sp_get_codelist}()},
\code{\link{sp_get_table}()}
}
\concept{Core workflow}
