% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht_2pop_var.R
\name{ht_2pop_var}
\alias{ht_2pop_var}
\title{F Test to compare two variances}
\usage{
ht_2pop_var(
  x,
  y,
  ratio = 1,
  alternative = "two.sided",
  conf_level = FALSE,
  sig_level = 0.05,
  na_rm = FALSE
)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{y}{a (non-empty) numeric vector.}

\item{ratio}{the hypothesized ratio of the population variances of \code{x} and \code{y}. Default value is 1.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf_level}{a number indicating the confidence level to compute the confidence interval. If \code{conf_level = NULL}, then the confidence interval is not included in the output. Default value is \code{NULL}.}

\item{sig_level}{a number indicating the significance level to use in the General Procedure for Hypothesis Testing.}

\item{na_rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds. Default value is \code{FALSE}.}
}
\value{
a \code{tibble} with the following columns:
\describe{
\item{statistic}{the value of the test statistic.}
\item{p_value}{the p-value for the test.}
\item{critical_value}{critical value in the General Procedure for Hypothesis Testing.}
\item{critical_region}{critical region in the General Procedure for Hypothesis Testing.}
\item{ratio}{a scalar value indicating the value of \code{ratio}.}
\item{alternative}{character string giving the direction of the alternative hypothesis.}
\item{lower_ci}{lower bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
\item{upper_ci}{upper bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
}
}
\description{
Performs a F test to compare the variances of two normal populations.
}
\details{
We have wrapped the \code{var.test} in a function as explained in the book of Montgomery and Runger (2010) <ISBN: 978-1-119-74635-5>.
}
\examples{
x <- rnorm(100, sd = 2)
y <- rnorm(1000, sd = 10)
ht_2pop_var(x, y)
}
