% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrIII2.R
\name{burrIII2}
\alias{burrIII2}
\alias{dburrIII2}
\alias{qburrIII2}
\alias{pburrIII2}
\alias{rburrIII2}
\alias{sburrIII2}
\title{Burr Type III Two-Parameter Distribution}
\usage{
dburrIII2(x, lshape = 0, lscale = 1, log = FALSE)

qburrIII2(p, lshape = 0, lscale = 1, lower.tail = TRUE, log.p = FALSE)

pburrIII2(q, lshape = 0, lscale = 1, lower.tail = TRUE, log.p = FALSE)

rburrIII2(n, lshape = 0, lscale = 1)

sburrIII2(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{lshape}{shape parameter on the log scale.}

\item{lscale}{scale parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function, random generation
and starting values for the
Burr Type III two-parameter distribution
with \code{lshape} and \code{lscale} parameters.
}
\details{
The Burr 12 distribution from the actuar package is used as a base.
The Burr III distribution is the distribution of 1/x where x has the Burr Type 12 distribution.
refer to
\url{https://www.itl.nist.gov/div898/software/dataplot/refman2/auxillar/bu3pdf.htm } for details.
The shape1, shape2, and scale parameters are on the log(scale) as these must be positive.
The two shape parameters are set to be equal to produce a two-parameter model.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dburrIII2(x), type = "l")
}
\seealso{
\code{\link[actuar]{dburr}} and \code{\link{burrIII3}}
}
