% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knit_print.R
\name{knit_print.spiro}
\alias{knit_print.spiro}
\title{Printing spiro data frames in a knitr context}
\usage{
\method{knit_print}{spiro}(x, min = 10, max = 20, digits = 2, ...)
}
\arguments{
\item{x}{A \code{data.frame} of the class \code{spiro} to be printed.}

\item{min}{An integer, which sets the number of rows to which \code{x} will
be limited in printing if row number exceed \code{max}.}

\item{max}{An integer, setting the maximal number of rows to be not cut to
\code{min} in printing.}

\item{digits}{An integer giving the number of decimals to be rounded to.}

\item{...}{Passing of additional arguments to \code{knit_print.default()}.}
}
\value{
The function prints its argument and returns it invisibly.
}
\description{
\code{knit_print.spiro()} provides a method for printing \code{data.frames}
from \code{\link{spiro}} within \code{knitr}.
}
\details{
Cardiopulmonary exercise testing data imported by \code{\link{spiro}} will
often come in large \code{data.frame}s. When knitting R Markdown documents
these will normally be printed in full size.

This function provides a method for \code{data.frame}s of the class
\code{spiro} to limit the number of rows displayed to \code{min} if it
exceeds \code{max}. The number of hidden data rows will be printed below the
\code{data.frame}.
}
\examples{
# Get example data
s <- spiro(spiro_example("zan_gxt"))

knitr::knit_print(s)
}
