% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distanceDist}
\alias{distanceDist}
\title{Collecting all pairwise distances between input planes.}
\usage{
distanceDist(planes, nn = FALSE)
}
\arguments{
\item{planes}{Input planes (e.g. result of guided tour)}

\item{nn}{Set true to only consider nearest neighbour distances (dummy, not yet implemented)}
}
\value{
numeric vector containing all distances
}
\description{
The distribution of all pairwise distances is useful to understand
the optimisation in a guided tour, to compare e.g. different optimisation
methods or different number of noise dimensions.
}
\examples{
planes1 <- purrr::rerun(10, tourr::basis_random(5))
planes2 <- purrr::rerun(10, tourr::basis_random(10))
d1 <- distanceDist(planes1)
d2 <- distanceDist(planes2)
d <- tibble::tibble(dist=c(d1, d2), dim=c(rep(5,length(d1)),rep(10,length(d2))))
ggplot2::ggplot(d) + ggplot2::geom_boxplot(ggplot2::aes(factor(dim), dist))
}
