% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonics.R
\name{harmonics}
\alias{harmonics}
\alias{g_i_k}
\title{(Hyper)spherical harmonics}
\usage{
g_i_k(x, i = 1, k = 1, m = NULL, show_m = FALSE)
}
\arguments{
\item{x}{locations in \eqn{S^{p-1}} to evaluate \eqn{g_{i,k}}. Either a
matrix of size \code{c(nx, p)} or a vector of size \code{p}. Normalized
internally if required (with a \code{warning} message).}

\item{i, k}{alternative indexing to refer to the \code{i}-th (hyper)spherical
harmonic of order \code{k}. \code{i} is a positive integer smaller than
\code{\link[=Sobolev]{d_p_k}} and \code{k} is a non-negative integer.}

\item{m}{(hyper)spherical harmonic index, as used in Proposition 3.1. The
index is computed internally from \code{i} and \code{k}. Defaults to
\code{NULL}.}

\item{show_m}{flag to print \code{m} if computed internally when
\code{m = NULL}.}
}
\value{
A vector of size \code{nrow(x)}.
}
\description{
Computation of a certain explicit representation of
(hyper)spherical harmonics on
\eqn{S^{p-1}:=\{{\bf x}\in R^p:||{\bf x}||=1\}}{
S^{p-1}:=\{x\in R^p:||x||=1\}}, \eqn{p\ge 2}. Details are available in
García-Portugués et al. (2024).
}
\details{
The implementation uses Proposition 3.1 in García-Portugués et al. (2024),
which adapts Theorem 1.5.1 in Dai and Xu (2013) with the correction of
typos in the normalizing constant \eqn{h_\alpha} and in the definition of
the function \eqn{g_\alpha} of the latter theorem.
}
\examples{
n <- 3e3
old_par <- par(mfrow = c(2, 3))
k <- 2
for (i in 1:d_p_k(p = 3, k = k)) {
  X <- r_unif_sph(n = n, p = 3, M = 1)[, , 1]
  col <- rainbow(n)[rank(g_i_k(x = X, k = k, i = i, show_m = TRUE))]
  scatterplot3d::scatterplot3d(X[, 1], X[, 2], X[, 3], color = col,
                               axis = FALSE, pch = 19)
}
for (k in 0:5) {
  X <- r_unif_sph(n = n, p = 3, M = 1)[, , 1]
  col <- rainbow(n)[rank(g_i_k(x = X, k = k, i = 1, show_m = TRUE))]
  scatterplot3d::scatterplot3d(X[, 1], X[, 2], X[, 3], color = col,
                               axis = FALSE, pch = 19)
}
par(old_par)
}
\references{
Dai, F. and Xu, Y. (2013). \emph{Approximation Theory and Harmonic Analysis
on Spheres and Balls}. Springer, New York. \doi{10.1007/978-1-4614-6660-4}

García-Portugués, E., Paindaveine, D., and Verdebout, T. (2024). On a class
of Sobolev tests for symmetry of directions, their detection thresholds, and
asymptotic powers. \emph{arXiv:2108.09874v2}.
\doi{10.48550/arXiv.2108.09874}
}
