% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralNMF.R
\name{spectralNMF}
\alias{spectralNMF}
\title{Perform Non-Negative Matrix factorization on spectral data}
\usage{
spectralNMF(object, rank, method = "PGNMF", initSpectralData = NULL,
  nruns = 10, subsamplingFactor = 3, checkDivergence = TRUE)
}
\arguments{
\item{object}{\code{\link{SpectraInTime-class}}}

\item{rank}{number of NMF components to be found}

\item{method}{name of the NMF method to be used. "PGNMF" (default), "HALSacc" 
and "semiNMF" are methods derived from the hNMF package. All methods from the NMF package are also available.}

\item{initSpectralData}{this can be a list of spectralData objects, containing 
the pure component spectra. It can also be either of the NMF factor matrices with initial values}

\item{nruns}{number of NMF runs. It is recommended to run the NMF analyses multiple
times when random seeding is used, to avoid a suboptimal solution}

\item{subsamplingFactor}{subsampling factor used during NMF analysis}

\item{checkDivergence}{Boolean indicating whether divergence checking should be performed}
}
\value{
Scaled NMF model (in accordance with the NMF package definition)
}
\description{
Perform Non-Negative Matrix factorization on spectral data
}
\author{
Nicolas Sauwen
}
