% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTrajectory.R
\name{GetTrajectory}
\alias{GetTrajectory}
\title{Gets a satellite trajectory}
\source{
\url{https://api.spectator.earth/#trajectories}
}
\usage{
GetTrajectory(satellite)
}
\arguments{
\item{satellite}{character name of the satellite for which to retrieve the trajectory.
The satellite name is not case sensitive, and can be abbreviated as long as an unambiguous match can be obtained.
Only one satellite can be queried at a time.}
}
\value{
Object of class '\code{sf}' with '\code{LINESTRING}' geometry type
}
\description{
Gets the current trajectory for the specified satellite.
}
\examples{
if(interactive()){
 library(sf)
 # get trajectory and current position for a selected satellite
 sat <- "SPOT-7"
 traj <- GetTrajectory(satellite = sat)
 pos <- GetSatellite(satellite = sat, positions = TRUE)
 # do some nice graphs
 library(maps)
 map("world", fill = TRUE, col = "lightgrey")
 plot(st_geometry(traj), lwd = 2, col = "red", add = TRUE)
 plot(st_geometry(pos), pch = 15, col = "green", cex = 1.5, add = TRUE)
 title(main = sprintf("current \%s trajectory & position", sat))
 }
}
