% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{print.coefspar}
\alias{print.coefspar}
\title{Print method for coefspar objects}
\usage{
\method{print}{coefspar}(x, digits = 4L, show = 6L, ...)
}
\arguments{
\item{x}{An object of class \code{'coefspar'}, typically created by a custom model function.}

\item{digits}{integer digits to be printed, defaults to 4L.}

\item{show}{integer number of coefficients to be shown, defaults to 6L.}

\item{...}{Additional arguments passed to or from other methods (ignored here).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Print method showing the basic components of a  \code{'coefspar'} object.
}
\examples{
example_data <- simulate_spareg_data(n = 200, p = 2000, ntest = 100)
spar_res <- spareg(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30))
coef(spar_res)
coef(spar_res, aggregate = "median")
coef(spar_res, aggregate = "none")
print(coef(spar_res), show = 10L, digits = 6L)
}
