% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available-data.R
\name{spod_available_data_v2}
\alias{spod_available_data_v2}
\title{Get the data dictionary}
\usage{
spod_available_data_v2(
  data_dir = spod_get_data_dir(),
  check_local_files = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{data_dir}{The directory where the data is stored. Defaults to the value returned by \code{spod_get_data_dir()}.}

\item{check_local_files}{Whether to check if the local files exist. Defaults to \code{FALSE}.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Default is \code{FALSE}.}
}
\value{
A tibble with links, release dates of files in the data, dates of data coverage, local paths to files, and the download status.
\describe{
\item{target_url}{\code{character}. The URL link to the data file.}
\item{pub_ts}{\code{POSIXct}. The timestamp of when the file was published.}
\item{file_extension}{\code{character}. The file extension of the data file (e.g., 'tar', 'gz').}
\item{data_ym}{\code{Date}. The year and month of the data coverage, if available.}
\item{data_ymd}{\code{Date}. The specific date of the data coverage, if available.}
\item{local_path}{\code{character}. The local file path where the data is stored.}
\item{downloaded}{\code{logical}. Indicator of whether the data file has been downloaded locally. This is only available if \code{check_local_files} is \code{TRUE}.}
}
}
\description{
This function retrieves the data dictionary for the specified data directory.
}
\keyword{internal}
