% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertModulSpec.R
\name{filterMS}
\alias{filterMS}
\title{Filter modulation spectrum}
\usage{
filterMS(
  ms,
  amCond = NULL,
  fmCond = NULL,
  jointCond = NULL,
  action = c("remove", "preserve")[1],
  plot = TRUE
)
}
\arguments{
\item{ms}{a modulation spectrum as returned by
\code{\link{modulationSpectrum}} - a matrix of real or complex values, AM
in columns, FM in rows}

\item{amCond, fmCond}{character strings with valid conditions on amplitude and
frequency modulation (see examples)}

\item{jointCond}{character string with a valid joint condition amplitude and
frequency modulation}

\item{action}{should the defined AM-FM region be removed ('remove') or
preserved, while everything else is removed ('preserve')?}

\item{plot}{if TRUE, plots the filtered modulation spectrum}
}
\value{
Returns the filtered modulation spectrum - a matrix of the original
  dimensions, real or complex.
}
\description{
Filters a modulation spectrum by removing a certain range of amplitude
modulation (AM) and frequency modulation (FM) frequencies. Conditions can be
specified either separately for AM and FM with \code{amCond = ..., fmCond =
...}, implying an OR combination of conditions, or jointly on AM and FM with
\code{jointCond}. \code{jointCond} is more general, but using
\code{amCond/fmCond} is ~100 times faster.
}
\examples{
ms = modulationSpectrum(soundgen(), samplingRate = 16000,
                        returnComplex = TRUE)$complex
# Remove all AM over 25 Hz
ms_filt = filterMS(ms, amCond = 'abs(am) > 25')

# amCond and fmCond are OR-conditions
filterMS(ms, amCond = 'abs(am) > 15', fmCond = 'abs(fm) > 5', action = 'remove')
filterMS(ms, amCond = 'abs(am) > 15', fmCond = 'abs(fm) > 5', action = 'preserve')
filterMS(ms, amCond = 'abs(am) > 10 & abs(am) < 25', action = 'remove')

# jointCond is an AND-condition
filterMS(ms, jointCond = 'am * fm < 5', action = 'remove')
filterMS(ms, jointCond = 'am^2 + (fm*3)^2 < 200', action = 'preserve')

# So:
filterMS(ms, jointCond = 'abs(am) > 5 | abs(fm) < 5')  # slow but general
# ...is the same as:
filterMS(ms, amCond = 'abs(am) > 5', fmCond = 'abs(fm) < 5')  # fast
}
