structure(list(method = "GET", url = "https://api.us.socrata.com/api/catalog/v1?limit=10&only=dataset&provenance=official", 
    status_code = 200L, headers = structure(list(Server = "nginx", 
        Date = "Tue, 22 Jul 2025 20:42:00 GMT", `Content-Type` = "application/json;charset=utf-8", 
        `Transfer-Encoding` = "chunked", Connection = "keep-alive", 
        `Access-Control-Allow-Origin` = "*", Vary = "Accept-Encoding", 
        `Content-Encoding` = "gzip", `X-Socrata-Region` = "aws-us-east-1-fedramp-prod", 
        `Strict-Transport-Security` = "max-age=31536000; includeSubDomains"), class = "httr2_headers"), 
    body = charToRaw("{\n  \"results\" :\n    [\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Dallas Police Active Calls\",\n            \"id\" : \"9fxf-t2tr\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"<b><p>Due to technical issues the Active Calls dataset may experience intermittent delays in automated data refreshing.</b></p>\\n<b>Staff is actively monitoring the situation.</b>\\n\\n<p>The calls listed here are only those where the element assigned to the call has arrived and is currently working the call.   It does not include any calls for service, whether currently being worked or not, that are not releasable due to privacy laws. </p>\",\n            \"attribution\" : \"Dallas Police Department\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T20:40:56.000Z\",\n            \"createdAt\" : \"2013-10-08T16:07:58.000Z\",\n            \"metadata_updated_at\" : \"2023-07-07T15:17:44.000Z\",\n            \"data_updated_at\" : \"2025-07-22T20:40:56.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 14224,\n                \"page_views_last_month\" : 68703,\n                \"page_views_total\" : 9208281,\n                \"page_views_last_week_log\" : 13.796141032081307,\n                \"page_views_last_month_log\" : 16.068106475858773,\n                \"page_views_total_log\" : 23.134500585436783\n              },\n            \"columns_name\" :\n              [\n                \"Division\",\n                \"Nature of Call\",\n                \"Block\",\n                \"Time\",\n                \"Beat\",\n                \"Location\",\n                \"Reporting Area\",\n                \"Incident Number\",\n                \"Date\",\n                \"Status\",\n                \"Priority\",\n                \"Unit Num\",\n                \"Date_Time\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"division\",\n                \"nature_of_call\",\n                \"block\",\n                \"time\",\n                \"beat\",\n                \"location\",\n                \"reporting_area\",\n                \"incident_number\",\n                \"date\",\n                \"status\",\n                \"priority\",\n                \"unit_number\",\n                \"date_time\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\"\n              ],\n            \"columns_description\" :\n              [\n                \"The Largest of the police geographic areas ( 7 patrol divisions)\",\n                \"Problem type of call, for example loud music, burglary…etc.\",\n                \"Block number of address for the call\",\n                \"Call Time\",\n                \"The 2nd to smallest police geography (Beats are made of Reporting Areas)\",\n                \"Street name of address for call\",\n                \"Smallest police geography which makes up all other police geographic areas (Beats, Sectors, Divisions)\",\n                \"Master incident number as it relates to the call (different from incident as it relates to an offense)\",\n                \"Call Date\",\n                \"Status of the call as it relates to the responding officers\",\n                \"Calls are broken down to priority type 1-4,…. 1 being most urgent\",\n                \"Responding officers element (unit) number\",\n                \"Date and Time of the call\"\n              ],\n            \"columns_format\" :\n              [\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {}\n              ],\n            \"download_count\" : 6296781,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-05-14T21:33:38.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Public Safety\",\n            \"domain_tags\" :\n              [\n                \"abrasion\",\n                \"accident\",\n                \"active calls\",\n                \"aggression\",\n                \"alcohol\",\n                \"arrest\",\n                \"assault\",\n                \"bruise\",\n                \"burglary\",\n                \"crime\",\n                \"criminal\",\n                \"disturbance\",\n                \"dpd\",\n                \"drugs\",\n                \"fraud\",\n                \"gun\",\n                \"handcuff\",\n                \"harassment\",\n                \"illegal\",\n                \"marijuana\",\n                \"motor\",\n                \"officer\",\n                \"police\",\n                \"prisoner\",\n                \"property\",\n                \"prowler\",\n                \"public safety\",\n                \"racing\",\n                \"resistance\",\n                \"robbery\",\n                \"shooting\",\n                \"speeding\",\n                \"street\",\n                \"theft\",\n                \"violence\",\n                \"warrant\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Additional-Information_Scope\",\n                  \"value\" : \"Official Data\"\n                },\n                {\n                  \"key\" : \"Additional-Information_Update-Frequency\",\n                  \"value\" : \"Every 2 Minutes\"\n                },\n                {\n                  \"key\" : \"Custom-Metadata-Fields_Category\",\n                  \"value\" : \"Public Safety\"\n                },\n                {\n                  \"key\" : \"Custom-Metadata-Fields_Data-Type\",\n                  \"value\" : \"File (Excel, CSV)\"\n                },\n                {\n                  \"key\" : \"Custom-Metadata-Fields_Contact-Email\",\n                  \"value\" : \"dldpdcrimeanalysis@dallascityhall.com\"\n                },\n                {\n                  \"key\" : \"Custom-Metadata-Fields_Automated-Updates\",\n                  \"value\" : \"Yes\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"www.dallasopendata.com\",\n            \"license\" : \"Open Data Commons Attribution License\"\n          },\n        \"permalink\" : \"https://www.dallasopendata.com/d/9fxf-t2tr\",\n        \"link\" : \"https://www.dallasopendata.com/Public-Safety/Dallas-Police-Active-Calls/9fxf-t2tr\",\n        \"owner\" :\n          {\n            \"id\" : \"jhxk-y6ib\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Dallas OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"jhxk-y6ib\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Dallas OpenData\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Lottery Cash 4 Life Winning Numbers: Beginning 2014\",\n            \"id\" : \"kwxv-fwze\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Go to http://on.ny.gov/1xRIvPz on the New York Lottery website for past Cash 4 Life results and payouts.\",\n            \"attribution\" : \"New York State Gaming Commission\",\n            \"attribution_link\" : \"http://nylottery.ny.gov/wps/portal/Home/Lottery/home/your+lottery/drawing+results/drawingresults_cash4life\",\n            \"contact_email\" : \"opendata@its.ny.gov\",\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T10:01:23.000Z\",\n            \"createdAt\" : \"2014-06-17T19:47:54.000Z\",\n            \"metadata_updated_at\" : \"2025-07-22T10:01:23.000Z\",\n            \"data_updated_at\" : \"2025-07-22T10:01:23.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 1932,\n                \"page_views_last_month\" : 3472,\n                \"page_views_total\" : 5955963,\n                \"page_views_last_week_log\" : 10.916625922211237,\n                \"page_views_last_month_log\" : 11.761966695382092,\n                \"page_views_total_log\" : 22.50590360310006\n              },\n            \"columns_name\" : [ \"Winning Numbers\", \"Draw Date\", \"Cash Ball\" ],\n            \"columns_field_name\" :\n              [ \"winning_numbers\", \"draw_date\", \"cash_ball\" ],\n            \"columns_datatype\" : [ \"Text\", \"Calendar date\", \"Text\" ],\n            \"columns_description\" :\n              [ \"Winning numbers\", \"Draw date\", \"Cash ball\" ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"center\" },\n                { \"view\" : \"date\", \"align\" : \"center\" },\n                { \"align\" : \"center\" }\n              ],\n            \"download_count\" : 246254,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2021-04-27T14:13:45.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Government & Finance\",\n            \"domain_tags\" :\n              [ \"cash 4 life\", \"new york lottery\", \"results\", \"winning\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Common-Core_Publisher\",\n                  \"value\" : \"State of New York\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Name\",\n                  \"value\" : \"Open Data NY\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Email\",\n                  \"value\" : \"opendata@its.ny.gov\"\n                },\n                {\n                  \"key\" : \"Additional-Resources_See-Also\",\n                  \"value\" : \"http://www.gaming.ny.gov/\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Dataset-Owner\",\n                  \"value\" : \"New York State Gaming Commission\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Contact-Information\",\n                  \"value\" : \"Info@gaming.ny.gov\"\n                },\n                { \"key\" : \"Dataset-Summary_Granularity\", \"value\" : \"By draw\" },\n                { \"key\" : \"Dataset-Summary_Coverage\", \"value\" : \"Statewide\" },\n                {\n                  \"key\" : \"Dataset-Summary_Data-Frequency\",\n                  \"value\" : \"Daily beginning 7/1/19; twice weekly previously\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Posting-Frequency\",\n                  \"value\" : \"Daily\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Organization\",\n                  \"value\" : \"The New York Lottery\"\n                },\n                {\n                  \"key\" : \"Dataset-Summary_Time-Period\",\n                  \"value\" : \"Beginning 6/16/2014\"\n                },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Gaming Commission, New York State\"\n                },\n                {\n                  \"key\" : \"Notes_Notes\",\n                  \"value\" : \"The information contained on these pages is believed to be accurate. In the event of a discrepancy between the information displayed on this Web site concerning winning numbers and payouts and the information contained in the official and certified files maintained by the New York Lottery's Drawing Unit, those maintained by the Drawing Unit shall prevail.\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.ny.gov\" },\n        \"permalink\" : \"https://data.ny.gov/d/kwxv-fwze\",\n        \"link\" : \"https://data.ny.gov/Government-Finance/Lottery-Cash-4-Life-Winning-Numbers-Beginning-2014/kwxv-fwze\",\n        \"owner\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xzik-pf59\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NY Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Provisional COVID-19 Deaths by Sex and Age\",\n            \"id\" : \"9bhg-hcku\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Effective September 27, 2023, this dataset will no longer be updated. Similar data are accessible from wonder.cdc.gov.\\n\\nDeaths involving COVID-19, pneumonia, and influenza reported to NCHS by sex, age group, and jurisdiction of occurrence.\",\n            \"attribution\" : \"NCHS/DVS\",\n            \"attribution_link\" : \"https://www.cdc.gov/nchs/nvss/vsrr/covid_weekly/index.htm\",\n            \"contact_email\" : \"cdcinfo@cdc.gov\",\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-04-21T16:20:29.000Z\",\n            \"createdAt\" : \"2020-05-01T16:01:23.000Z\",\n            \"metadata_updated_at\" : \"2025-04-21T16:20:29.000Z\",\n            \"data_updated_at\" : \"2023-09-27T14:43:31.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 1523,\n                \"page_views_last_month\" : 5875,\n                \"page_views_total\" : 4239731,\n                \"page_views_last_week_log\" : 10.573647187493323,\n                \"page_views_last_month_log\" : 12.52061868055628,\n                \"page_views_total_log\" : 22.015541642015755\n              },\n            \"columns_name\" :\n              [\n                \"Year\",\n                \"COVID-19 Deaths\",\n                \"Pneumonia Deaths\",\n                \"Footnote\",\n                \"Month\",\n                \"Sex\",\n                \"Pneumonia and COVID-19 Deaths\",\n                \"State\",\n                \"End Date\",\n                \"Pneumonia, Influenza, or COVID-19 Deaths\",\n                \"Start Date\",\n                \"Data As Of\",\n                \"Group\",\n                \"Age Group\",\n                \"Total Deaths\",\n                \"Influenza Deaths\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"year\",\n                \"covid_19_deaths\",\n                \"pneumonia_deaths\",\n                \"footnote\",\n                \"month\",\n                \"sex\",\n                \"pneumonia_and_covid_19_deaths\",\n                \"state\",\n                \"end_date\",\n                \"pneumonia_influenza_or_covid\",\n                \"start_date\",\n                \"data_as_of\",\n                \"group\",\n                \"age_group\",\n                \"total_deaths\",\n                \"influenza_deaths\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Calendar date\",\n                \"Number\",\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Year in which death occurred\",\n                \"Deaths involving COVID-19 (ICD-code U07.1)\",\n                \"Pneumonia Deaths (ICD-10 codes J12.0-J18.9)\",\n                \"Suppressed counts (1-9)\",\n                \"Month in which death occurred\",\n                \"Sex\",\n                \"Deaths with Pneumonia and COVID-19 (ICD-10 codes J12.0-J18.9 and U07.1)\",\n                \"Jurisdiction of occurrence\",\n                \"Last date of data period\",\n                \"Deaths with Pneumonia, Influenza, or COVID-19 (ICD-10 codes U07.1 or J09-J18.9)\",\n                \"First date of data period\",\n                \"Date of analysis\",\n                \"Indicator of whether data measured by Month, by Year, or Total\",\n                \"Age group\",\n                \"Deaths from all causes of death\",\n                \"Influenza Deaths (ICD-10 codes J09-J11)\"\n              ],\n            \"columns_format\" :\n              [\n                { \"noCommas\" : \"true\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {},\n                {},\n                {},\n                { \"align\" : \"right\" },\n                {},\n                { \"view\" : \"date\" },\n                { \"align\" : \"right\" },\n                { \"view\" : \"date\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                {},\n                { \"align\" : \"right\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"right\" }\n              ],\n            \"download_count\" : 560063,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2021-02-24T20:02:36.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"National Center for Health Statistics\",\n            \"domain_tags\" :\n              [\n                \"age\",\n                \"age group\",\n                \"coronavirus\",\n                \"covid-19\",\n                \"deaths\",\n                \"influenza\",\n                \"monthly\",\n                \"mortality\",\n                \"nchs\",\n                \"nvss\",\n                \"pneumonia\",\n                \"provisional\",\n                \"puerto rico\",\n                \"sex\",\n                \"state\",\n                \"united states\",\n                \"yearly\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Common-Core_Contact-Email\",\n                  \"value\" : \"cdcinfo@cdc.gov\"\n                },\n                { \"key\" : \"Common-Core_Program-Code\", \"value\" : \"009:020\" },\n                {\n                  \"key\" : \"Common-Core_Public-Access-Level\",\n                  \"value\" : \"public\"\n                },\n                {\n                  \"key\" : \"Common-Core_Temporal-Applicability\",\n                  \"value\" : \"2020-01-01/2023-07-29\"\n                },\n                {\n                  \"key\" : \"Common-Core_Geographic-Coverage\",\n                  \"value\" : \"United States, Puerto Rico\"\n                },\n                {\n                  \"key\" : \"Common-Core_Publisher\",\n                  \"value\" : \"National Center for Health Statistics\"\n                },\n                {\n                  \"key\" : \"Common-Core_Update-Frequency\",\n                  \"value\" : \"irregular\"\n                },\n                {\n                  \"key\" : \"Common-Core_Homepage\",\n                  \"value\" : \"https://www.cdc.gov/nchs/covid19/covid-19-mortality-data-files.htm\"\n                },\n                { \"key\" : \"Common-Core_Bureau-Code\", \"value\" : \"009:20\" },\n                { \"key\" : \"Common-Core_Issued\", \"value\" : \"2020-05-01\" },\n                {\n                  \"key\" : \"Common-Core_Contact-Name\",\n                  \"value\" : \"National Center for Health Statistics\"\n                },\n                {\n                  \"key\" : \"Data-Quality_Suggested-Citation\",\n                  \"value\" : \"National Center for Health Statistics. Provisional COVID-19 Deaths by Sex and Age. Date accessed [Last accessed date]. Available from https://data.cdc.gov/d/9bhg-hcku.\"\n                },\n                {\n                  \"key\" : \"Data-Quality_Geographic-Coverage\",\n                  \"value\" : \"United States, Puerto Rico\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cdc.gov\",\n            \"license\" : \"Public Domain U.S. Government\"\n          },\n        \"permalink\" : \"https://data.cdc.gov/d/9bhg-hcku\",\n        \"link\" : \"https://data.cdc.gov/National-Center-for-Health-Statistics/Provisional-COVID-19-Deaths-by-Sex-and-Age/9bhg-hcku\",\n        \"owner\" :\n          {\n            \"id\" : \"xfvr-ns68\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NCHS\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"xfvr-ns68\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NCHS\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"COVID-19 Public Therapeutic Locator\",\n            \"id\" : \"rxn6-qnx8\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"<b>NOTE: This dataset is no longer updated as of 1/31/2024. Please use <a href=\\\"https://healthdata.gov/ASPR/COVID-19-Treatments/xkzp-zhs7/about_data\\\">COVID-19 Treatments.</a></b>\\n<p>\\nLocations of publicly available COVID-19 Therapeutics. Dataset only includes locations for Paxlovid (oral antiviral), Lagevrio (oral antiviral), and outpatient Veklury (intravenous antiviral infusion). COVID-19 therapeutics require a prescription to obtain. Limitations: public contact information.\\n</p>\\n<p>\\n<b> To filter, click 'View Data' below, then 'Filter.' To save your view, click 'Save as,' and this configuration will be saved in your profile under 'My Assets.' <u>Please try not to publish dataset publicly, unless necessary.</b></u>\\n</p>\\n\\nOn 1/3/2022 - The following changes were made to this dataset.\\n- Dropped the Expected Deliver Date column - This was a derived field set to 3 days after the Last Order Date field.\\n- Added the following fields\\n   Last Date Delivered\\n   Total Courses\\n   Courses Available\\n   Courses Available Date\\n\\nOn 1/4/2022 - Added Geocoded Address\\n\\nOn 1/11/2022 - Added NPI - National Provider Identifier\\n\\nOn 2/18/2022 - Added new therapeutics, Bebtelovimab & Sotrovimab.\\n\\nOn 3/16/2022 - Dropped the following columns\\n      - last_order_date\\n      - last_date_delivered\\n      - total_courses\\n      - courses_available_date\\n   Added the following columns\\n      - facility_id\\n      - last_report_date\\n      - grantee_code\\n      - provider_pin\\n      - state_provider_pin\\n\\nOn 3/31/2022 - Dropped the following columns\\n      - facility_id\\n      - grantee_code\\n      - provider_pin\\n      - state_provider_pin\\n   Added the following columns\\n      - provider_status\\n      - provider_note\",\n            \"attribution\" : \"U.S. Department of Health & Human Services\",\n            \"attribution_link\" : null,\n            \"contact_email\" : \"HealthData@hhs.gov\",\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-03T14:26:28.000Z\",\n            \"createdAt\" : \"2021-12-28T15:47:44.000Z\",\n            \"metadata_updated_at\" : \"2025-07-03T14:26:28.000Z\",\n            \"data_updated_at\" : \"2024-01-31T09:30:24.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 2,\n                \"page_views_last_month\" : 15,\n                \"page_views_total\" : 127,\n                \"page_views_last_week_log\" : 1.5849625007211563,\n                \"page_views_last_month_log\" : 4.0,\n                \"page_views_total_log\" : 7.0\n              },\n            \"columns_name\" :\n              [\n                \"City\",\n                \"Courses Available\",\n                \"Zip\",\n                \"Provider Name\",\n                \"Demo | State Geographic Boundaries\",\n                \"County\",\n                \"Address1\",\n                \"Geocoded Address\",\n                \"Order Label\",\n                \"Provider Status\",\n                \"Last Report Date\",\n                \"Provider Note\",\n                \"NPI\",\n                \"State Code\",\n                \"National Drug Code\",\n                \"Address2\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"city\",\n                \"courses_available\",\n                \"zip\",\n                \"provider_name\",\n                \":@computed_region_pqdx_y6mm\",\n                \"county\",\n                \"address1\",\n                \"geocoded_address\",\n                \"order_label\",\n                \"provider_status\",\n                \"last_report_date\",\n                \"provider_note\",\n                \"npi\",\n                \"state_code\",\n                \"national_drug_code\",\n                \"address2\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Provider's city\",\n                \"Total courses remaining in on-hand inventory at this provider site\",\n                \"Provider's Zip Code\",\n                \"Name of provider location receiving therapeutic product\",\n                \"This column was automatically created in order to record in what polygon from the dataset 'Demo | State Geographic Boundaries' (pqdx-y6mm) the point in column 'geocoded_address' is located.  This enables the creation of region maps (choropleths) in the visualization canvas and data lens.\",\n                \"Provider's county\",\n                \"Provider's address\",\n                \"The geocoded latitude and longitude of the therapeutic provider.\",\n                \"Therapeutic name\",\n                \"Provider's inventory status\",\n                \"The date the current therapeutic availability was last reported by given provider\",\n                \"Extended description for Provider Status\",\n                \"National Provider Identifier\\nhttps://npiregistry.cms.hhs.gov/\",\n                \"Provider's state\",\n                \"Therapeutic NDC\",\n                \"Provider's address\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 1056,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2022-03-31T19:09:22.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Health\",\n            \"domain_tags\" : [ \"covid-19\", \"hhs covid-19\", \"theraputic care\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Archive_Archive-Repository\",\n                  \"value\" : \"https://healthdata.gov/d/j7fh-jg79\"\n                },\n                {\n                  \"key\" : \"Common-Core_Contact-Email\",\n                  \"value\" : \"HealthData@hhs.gov\"\n                },\n                {\n                  \"key\" : \"Common-Core_Last-Update\",\n                  \"value\" : \"March 21, 2022, 14:16\"\n                },\n                { \"key\" : \"Common-Core_Program-Code\", \"value\" : \"009:028\" },\n                {\n                  \"key\" : \"Common-Core_Public-Access-Level\",\n                  \"value\" : \"public\"\n                },\n                { \"key\" : \"Common-Core_Is-Quality-Data\", \"value\" : \"true\" },\n                { \"key\" : \"Common-Core_Language\", \"value\" : \"English\" },\n                {\n                  \"key\" : \"Common-Core_Publisher\",\n                  \"value\" : \"U.S. Department of Health and Human Services\"\n                },\n                { \"key\" : \"Common-Core_Theme\", \"value\" : \"Health\" },\n                { \"key\" : \"Common-Core_Bureau-Code\", \"value\" : \"009:00\" },\n                {\n                  \"key\" : \"Common-Core_Contact-Name\",\n                  \"value\" : \"HealthData.gov Team\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"datahub.hhs.gov\",\n            \"license\" : \"Public Domain U.S. Government\"\n          },\n        \"permalink\" : \"https://datahub.hhs.gov/d/rxn6-qnx8\",\n        \"link\" : \"https://datahub.hhs.gov/Health/COVID-19-Public-Therapeutic-Locator/rxn6-qnx8\",\n        \"owner\" :\n          {\n            \"id\" : \"7rgq-62vg\",\n            \"user_type\" : \"team\",\n            \"display_name\" : \"Office of Chief Data Officer (OCDO)\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"7rgq-62vg\",\n            \"user_type\" : \"team\",\n            \"display_name\" : \"Office of Chief Data Officer (OCDO)\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Health Care Provider Credential Data\",\n            \"id\" : \"qxh8-f4bd\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"The Washington State Department of Health presents this information as a service to the public. True and correct copies of legal disciplinary actions taken after July 1998 are available on our Provider Credential Search site. These records are considered certified by the Department of Health. \\n\\nThis includes information on health care providers.\\n\\nPlease contact our Customer Service Center at 360-236-4700 for information about actions before July 1998. \\nThe information on this site comes directly from our database and is updated daily at 10:00 a.m.. This data is a primary source for verification of credentials and is extracted from the primary database at 2:00 a.m. daily.\\n\\nNews releases about disciplinary actions taken against Washington State healthcare providers, agencies or facilities are on the agency's Newsroom webpage.\\n\\nDisclaimer\\nThe absence of information in the Provider Credential Search system doesn't imply any recommendation, endorsement or guarantee of competence of any healthcare professional. The presence of information in this system doesn't imply a provider isn't competent or qualified to practice. The reader is encouraged to carefully evaluate any information found in this data set.\",\n            \"attribution\" : \"Washington State Department of Health\",\n            \"attribution_link\" : \"https://fortress.wa.gov/doh/providercredentialsearch/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T17:17:13.000Z\",\n            \"createdAt\" : \"2016-01-20T23:20:45.000Z\",\n            \"metadata_updated_at\" : \"2025-05-20T23:17:55.000Z\",\n            \"data_updated_at\" : \"2025-07-22T17:17:13.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 9239,\n                \"page_views_last_month\" : 37678,\n                \"page_views_total\" : 3739093,\n                \"page_views_last_week_log\" : 13.17367713630342,\n                \"page_views_last_month_log\" : 15.201473055907119,\n                \"page_views_total_log\" : 21.83425731001188\n              },\n            \"columns_name\" :\n              [\n                \"LastIssueDate\",\n                \"ExpirationDate\",\n                \"BirthYear\",\n                \"FirstIssueDate\",\n                \"CEDueDate\",\n                \"CredentialNumber\",\n                \"CredentialType\",\n                \"LastName\",\n                \"MiddleName\",\n                \"ActionTaken\",\n                \"FirstName\",\n                \"Status\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"lastissuedate\",\n                \"expirationdate\",\n                \"birthyear\",\n                \"firstissuedate\",\n                \"ceduedate\",\n                \"credentialnumber\",\n                \"credentialtype\",\n                \"lastname\",\n                \"middlename\",\n                \"actiontaken\",\n                \"firstname\",\n                \"status\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {} ],\n            \"download_count\" : 178056,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2016-01-25T17:39:10.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"public safety\", \"economy\", \"health\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"health\",\n            \"domain_tags\" :\n              [\n                \"care\",\n                \"credential\",\n                \"department\",\n                \"health\",\n                \"provider\",\n                \"public\",\n                \"state\",\n                \"washington\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Notes_1.-\",\n                  \"value\" : \"Application Status: A \\\"pending\\\" status means the review process is underway. We quickly update this status information from our licensing system, and it's a primary source for verifying your credentials.  https://www.doh.wa.gov/LicensesPermitsandCertificates/ProfessionsNewReneworUpdate/ApplicationStatus\"\n                },\n                {\n                  \"key\" : \"Notes_2.-\",\n                  \"value\" : \"Contact Us: https://www.doh.wa.gov/AboutUs/ProgramsandServices/HealthSystemsQualityAssurance/ContactUs#heading28603\"\n                },\n                {\n                  \"key\" : \"Notes_3.-\",\n                  \"value\" : \"Profession-Specific Guidance: https://www.doh.wa.gov/LicensesPermitsandCertificates/ProfessionsNewReneworUpdate\"\n                },\n                {\n                  \"key\" : \"Temporal_Period-of-Time\",\n                  \"value\" : \"1/1/1907 to present\"\n                },\n                { \"key\" : \"Temporal_Posting-Frequency\", \"value\" : \"Daily\" }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.wa.gov\", \"license\" : \"Public Domain\" },\n        \"permalink\" : \"https://data.wa.gov/d/qxh8-f4bd\",\n        \"link\" : \"https://data.wa.gov/health/Health-Care-Provider-Credential-Data/qxh8-f4bd\",\n        \"owner\" :\n          {\n            \"id\" : \"ypwc-5ce7\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Department of Health Open Data\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"ypwc-5ce7\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Department of Health Open Data\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Howard County Police Department Call For Service - 2014-2023\",\n            \"id\" : \"qccx-65fg\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Calls for Service by computer aided dispatch (CAD) event type, date, time, location, statistical reporting area (SRA), and beat.\",\n            \"attribution\" : null,\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-03-15T13:37:59.000Z\",\n            \"createdAt\" : \"2015-05-04T15:33:31.000Z\",\n            \"metadata_updated_at\" : \"2024-03-15T13:37:55.000Z\",\n            \"data_updated_at\" : \"2024-03-15T13:37:59.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 17,\n                \"page_views_last_month\" : 49,\n                \"page_views_total\" : 3675618,\n                \"page_views_last_week_log\" : 4.169925001442312,\n                \"page_views_last_month_log\" : 5.643856189774724,\n                \"page_views_total_log\" : 21.809555799689498\n              },\n            \"columns_name\" :\n              [\n                \"Beat\",\n                \"Statistical_Reporting_Area\",\n                \"Location\",\n                \"Time_Reported\",\n                \"Date_Reported\",\n                \"Computer_Aided_Dispatch_Event_Type\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"beat\",\n                \"statistical_reporting_area\",\n                \"location\",\n                \"time_reported\",\n                \"date_reported\",\n                \"computer_aided_dispatch_event_type\"\n              ],\n            \"columns_datatype\" :\n              [ \"Text\", \"Number\", \"Text\", \"Text\", \"Calendar date\", \"Text\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [ {}, {}, {}, {}, { \"view\" : \"date\", \"align\" : \"left\" }, {} ],\n            \"download_count\" : 1211,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-02-15T15:31:08.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Public Safety\",\n            \"domain_tags\" : [ \"beat\", \"cad\", \"calls\", \"dispatch\", \"sra\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Additional-Metadata_Coverage\",\n                  \"value\" : \"2014-2020\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Frequency\",\n                  \"value\" : \"Annually\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Publisher\",\n                  \"value\" : \"Howard County, MD\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Contributor\",\n                  \"value\" : \"Police Department\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"opendata.howardcountymd.gov\" },\n        \"permalink\" : \"https://opendata.howardcountymd.gov/d/qccx-65fg\",\n        \"link\" : \"https://opendata.howardcountymd.gov/Public-Safety/Howard-County-Police-Department-Call-For-Service-2/qccx-65fg\",\n        \"owner\" :\n          {\n            \"id\" : \"n9w7-tmda\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jeanne Upchurch\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"n9w7-tmda\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jeanne Upchurch\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"For Hire Vehicles (FHV) - Active\",\n            \"id\" : \"8wbx-tsch\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"<b>PLEASE NOTE:</b> This dataset, which includes all TLC licensed for-hire vehicles which are in good standing and able to drive, is updated every day in the evening between 4-7pm. Please check the 'Last Update Date' field to make sure the list has updated successfully. 'Last Update Date'  should show either today or yesterday's date, depending on the time of day. If the list is outdated, please download the most recent list from the link below. \\r\\nhttp://www1.nyc.gov/assets/tlc/downloads/datasets/tlc_for_hire_vehicle_active_and_inactive.csv\\r\\n\\r\\nTLC authorized For-Hire vehicles that are active. This list is accurate to the date and time represented in the Last Date Updated and Last Time Updated fields. For inquiries about the contents of this dataset, please email licensinginquiries@tlc.nyc.gov.\",\n            \"attribution\" : \"Taxi and Limousine Commission (TLC)\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T18:53:28.000Z\",\n            \"createdAt\" : \"2015-07-16T17:33:32.000Z\",\n            \"metadata_updated_at\" : \"2022-09-06T21:05:32.000Z\",\n            \"data_updated_at\" : \"2025-07-22T18:53:28.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 12649,\n                \"page_views_last_month\" : 61477,\n                \"page_views_total\" : 3303872,\n                \"page_views_last_week_log\" : 13.626849764469036,\n                \"page_views_last_month_log\" : 15.90778261164035,\n                \"page_views_total_log\" : 21.655726800333454\n              },\n            \"columns_name\" :\n              [\n                \"Vehicle Year\",\n                \"Reason\",\n                \"Wheelchair Accessible\",\n                \"Base Address\",\n                \"DMV License Plate Number\",\n                \"Base Type\",\n                \"VEH\",\n                \"Active\",\n                \"Vehicle VIN Number\",\n                \"Hack Up Date\",\n                \"Last Date Updated\",\n                \"Last Time Updated\",\n                \"Base Telephone Number\",\n                \"Base Number\",\n                \"Base Name\",\n                \"Certification Date\",\n                \"Permit License Number\",\n                \"Expiration Date\",\n                \"Name\",\n                \"Vehicle License Number\",\n                \"Order Date\",\n                \"Website\",\n                \"License Type\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"vehicle_year\",\n                \"reason\",\n                \"wheelchair_accessible\",\n                \"base_address\",\n                \"dmv_license_plate_number\",\n                \"base_type\",\n                \"veh\",\n                \"active\",\n                \"vehicle_vin_number\",\n                \"hack_up_date\",\n                \"last_date_updated\",\n                \"last_time_updated\",\n                \"base_telephone_number\",\n                \"base_number\",\n                \"base_name\",\n                \"certification_date\",\n                \"permit_license_number\",\n                \"expiration_date\",\n                \"name\",\n                \"vehicle_license_number\",\n                \"order_date\",\n                \"website\",\n                \"license_type\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Vehicle Year\",\n                \"Reason Code A,B,C or G\\n\",\n                \"Wheelchair Accessible Indicator\\n\",\n                \"Base Address\",\n                \"DMV License Plate Number\",\n                \"Base Type\",\n                \"Hybrid vehicle indicator\\n\",\n                \"Permit active or not\\n\",\n                \"Vehicle VIN Number\",\n                \"Hack Up Date\",\n                \"Last Date Updated\",\n                \"Last Time Updated\",\n                \"Base Telephone NumberBase Telephone Number\",\n                \"Base Number\",\n                \"Base Name\",\n                \"Certification Date\",\n                \"Permit License Number\",\n                \"Expiration Date\",\n                \"Owner Name\\n\",\n                \"FHV Vehicle License Number\",\n                \"Date Suspension ordered\\n\",\n                \"Base Website\",\n                \"TLC License Type\\n\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date_time\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" }\n              ],\n            \"download_count\" : 570990,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2021-04-05T13:20:47.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"active\",\n                \"drivers\",\n                \"fhv\",\n                \"for hire\",\n                \"for-hire\",\n                \"for-hire-vehicles\",\n                \"inactive\",\n                \"taxi\"\n              ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Update_Automation\", \"value\" : \"Yes\" },\n                { \"key\" : \"Update_Date-Made-Public\", \"value\" : \"7/20/2015\" },\n                { \"key\" : \"Update_Update-Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Taxi and Limousine Commission (TLC)\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofnewyork.us\" },\n        \"permalink\" : \"https://data.cityofnewyork.us/d/8wbx-tsch\",\n        \"link\" : \"https://data.cityofnewyork.us/Transportation/For-Hire-Vehicles-FHV-Active/8wbx-tsch\",\n        \"owner\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Civil Service List (Active)\",\n            \"id\" : \"vx8i-nprf\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"A Civil Service List consists of all candidates who passed an exam, ranked in score order. An established list is considered active for no less than one year and no more than four years from the date of establishment. For more information visit DCAS’ “Work for the City” webpage at: https://www1.nyc.gov/site/dcas/employment/take-an-exam.page\",\n            \"attribution\" : \"Department of Citywide Administrative Services (DCAS)\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T17:00:25.000Z\",\n            \"createdAt\" : \"2016-06-14T21:12:15.000Z\",\n            \"metadata_updated_at\" : \"2024-05-14T14:26:52.000Z\",\n            \"data_updated_at\" : \"2025-07-22T17:00:25.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 6734,\n                \"page_views_last_month\" : 28461,\n                \"page_views_total\" : 3045507,\n                \"page_views_last_week_log\" : 12.717462230349666,\n                \"page_views_last_month_log\" : 14.796749421902337,\n                \"page_views_total_log\" : 21.5382514634503\n              },\n            \"columns_name\" :\n              [\n                \"First Name\",\n                \"Sibling Lgy Credit\",\n                \"Residency Credit\",\n                \"List No\",\n                \"MI\",\n                \"List Agency Desc\",\n                \"Published Date\",\n                \"Established Date\",\n                \"Extension Date\",\n                \"Last Name\",\n                \"Group No\",\n                \"Exam No\",\n                \"List Title Desc\",\n                \"Anniversary Date\",\n                \"List Title Code\",\n                \"List Div Code\",\n                \"List Agency Code\",\n                \"Veteran Credit\",\n                \"Parent Lgy Credit\",\n                \"Adj. FA\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"first_name\",\n                \"sibling_lgy_credit\",\n                \"residency_credit\",\n                \"list_no\",\n                \"mi\",\n                \"list_agency_desc\",\n                \"published_date\",\n                \"established_date\",\n                \"extension_date\",\n                \"last_name\",\n                \"group_no\",\n                \"exam_no\",\n                \"list_title_desc\",\n                \"anniversary_date\",\n                \"list_title_code\",\n                \"list_div_code\",\n                \"list_agency_code\",\n                \"veteran_credit\",\n                \"parent_lgy_credit\",\n                \"adj_fa\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"A candidate’s first name as it appears on their application.\\n\",\n                \"A “Sibling Legacy Credit” is additional credit given on an exam (10 points) to a candidate who lost a sibling (FDNY, NYPD, or a First Responder, during or as a result of 911).\\n\",\n                \"An additional credit given on an exam to a candidate who maintains a continuous period of residency in New York City as described in the Notice of Examination for a specific title.     \\n\",\n                \"An eligible candidate’s placement on a given list as of the business day that the data set is populated. \\n\\n\",\n                \"A candidate’s middle initial (MI) as it appears on their application.\\n\",\n                \"The name of an appointing Agency.\\n\",\n                \"The date on which an eligible list is made available for review by the general public and appointing agencies.  \\n\",\n                \"The date on which an eligible list is made available for certification to agencies to consider an eligible candidate for appointment.\\n\",\n                \"The date on which a list will be extended beyond its original expiration date.  \\n\",\n                \"A candidate’s last name as it appears on their application.\\n\",\n                \"Represents the certification order for a list. (e.g. – eligible candidates on a list with a 01 group number may be considered for appointment before an eligible candidate on primary list with a 00 group number).\\n\",\n                \"A four (4) digit number that identifies a civil service examination. \\n\\n\",\n                \"A descriptive name that identifies a civil service title. \\n\",\n                \"The date on which an eligible list is scheduled to expire.      \\n\",\n                \"A five (5) digit number that corresponds to and represents a civil service title.\\n\",\n                \"The promotional division codes/descriptions within the New York City Transit Authority only.\\n\",\n                \"A three (3) digit number used to identify an agency (For Promotion List Only).\\n\",\n                \"An additional credit given to a Veteran (5 points) or disabled veteran (10 points) when s/he accepts a permanent position from an eligible list. \\n\",\n                \"A “Parent Legacy credit” is an additional credit given on an exam (10 points) to a candidate who lost a parent (FDNY, NYPD, or a First Responder, during or as a result of 911).\\n\",\n                \"The Adjusted Final Average (“Adj. FA” or “AFA”) is an eligible candidate’s test score in addition to any additional credits granted.\\n\"\n              ],\n            \"columns_format\" :\n              [\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"3\",\n                  \"align\" : \"left\"\n                },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"precision\" : \"2\",\n                  \"align\" : \"left\"\n                }\n              ],\n            \"download_count\" : 78269,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2024-01-12T16:15:05.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"City Government\",\n            \"domain_tags\" :\n              [\n                \"admin\",\n                \"cei\",\n                \"citywide equity and inclusion\",\n                \"civil service list\",\n                \"construction and technical services\",\n                \"cts\",\n                \"dcas\",\n                \"dem\",\n                \"department of citywide administrative services\",\n                \"department of energy management\",\n                \"eal estate services\",\n                \"exam\",\n                \"facilities management\",\n                \"fbm\",\n                \"fiscal and business management\",\n                \"fleet\",\n                \"fm\",\n                \"hc\",\n                \"human capital\",\n                \"name\",\n                \"ocp\",\n                \"office of citywide procurement\",\n                \"office of general counsel\",\n                \"ogc\",\n                \"rank\",\n                \"res\",\n                \"score\"\n              ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Update_Automation\", \"value\" : \"Yes\" },\n                { \"key\" : \"Update_Date-Made-Public\", \"value\" : \"7/12/2016\" },\n                { \"key\" : \"Update_Update-Frequency\", \"value\" : \"Daily\" },\n                { \"key\" : \"Update_Data-Change-Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Department of Citywide Administrative Services (DCAS)\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofnewyork.us\" },\n        \"permalink\" : \"https://data.cityofnewyork.us/d/vx8i-nprf\",\n        \"link\" : \"https://data.cityofnewyork.us/City-Government/Civil-Service-List-Active-/vx8i-nprf\",\n        \"owner\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Building, Electrical, Fire, Grading, Mechanical, Plumbing & Sign Permits\",\n            \"id\" : \"kvz2-j5cj\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Issued Permits - File Date:  5/23/2013 - 11/30/2024\",\n            \"attribution\" : \"Department of Inspections, Licenses & Permits\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2024-12-12T14:16:05.000Z\",\n            \"createdAt\" : \"2015-04-30T17:13:40.000Z\",\n            \"metadata_updated_at\" : \"2024-12-12T14:15:54.000Z\",\n            \"data_updated_at\" : \"2024-12-12T14:16:05.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 12,\n                \"page_views_last_month\" : 31,\n                \"page_views_total\" : 2391144,\n                \"page_views_last_week_log\" : 3.700439718141092,\n                \"page_views_last_month_log\" : 5.0,\n                \"page_views_total_log\" : 21.189270187637245\n              },\n            \"columns_name\" :\n              [\n                \"CITY\",\n                \"ISSUE_DATE\",\n                \"CENSUS_TRACT\",\n                \"PERMIT_TYPE\",\n                \"ZIP\",\n                \"FILE_DATE\",\n                \"TYPE\",\n                \"CATEGORY\",\n                \"PERMIT_NUMBER\",\n                \"SEWER\",\n                \"WATER\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"city\",\n                \"issue_date\",\n                \"census_tract\",\n                \"permit_type\",\n                \"zip\",\n                \"file_date\",\n                \"type\",\n                \"category\",\n                \"permit_number\",\n                \"sewer\",\n                \"water\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 1476,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2017-12-04T15:23:39.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"infrastructure\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Licenses and Permits\",\n            \"domain_tags\" :\n              [\n                \"building permit\",\n                \"electrical permit\",\n                \"fire permit\",\n                \"grading permit\",\n                \"hvac permit\",\n                \"issued permits\",\n                \"mechanical permit\",\n                \"permits\",\n                \"plumbing permit\",\n                \"sign permit\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Additional-Metadata_Coverage\",\n                  \"value\" : \"2010 - Present\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Frequency\",\n                  \"value\" : \"Yearly\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Publisher\",\n                  \"value\" : \"Howard County, Maryland\"\n                },\n                {\n                  \"key\" : \"Additional-Metadata_Contributor\",\n                  \"value\" : \"Department of Inspections, Licenses & Permits\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"opendata.howardcountymd.gov\",\n            \"license\" : \"Public Domain\"\n          },\n        \"permalink\" : \"https://opendata.howardcountymd.gov/d/kvz2-j5cj\",\n        \"link\" : \"https://opendata.howardcountymd.gov/Licenses-and-Permits/Building-Electrical-Fire-Grading-Mechanical-Plumbi/kvz2-j5cj\",\n        \"owner\" :\n          {\n            \"id\" : \"y48e-rpnp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Walker, C.\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"y48e-rpnp\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Walker, C.\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"DOB Job Application Filings\",\n            \"id\" : \"ic3t-wcy2\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset contains all job applications submitted through the Borough Offices, through eFiling, or through the HUB, which have a \\\"Latest Action Date\\\" since January 1, 2000. This dataset does not include jobs submitted through DOB NOW. See the <a href=\\\"https://data.cityofnewyork.us/d/w9ak-ipjd\\\" target=\\\"_blank\\\" rel=\\\"noreferrer\\\"\\n>DOB NOW: Build – Job Application Filings</a> dataset for DOB NOW jobs.\",\n            \"attribution\" : \"Department of Buildings (DOB)\",\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T20:02:20.000Z\",\n            \"createdAt\" : \"2013-04-18T15:18:56.000Z\",\n            \"metadata_updated_at\" : \"2025-07-11T18:35:13.000Z\",\n            \"data_updated_at\" : \"2025-07-22T20:02:20.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 577,\n                \"page_views_last_month\" : 2455,\n                \"page_views_total\" : 2384094,\n                \"page_views_last_week_log\" : 9.17492568250068,\n                \"page_views_last_month_log\" : 11.26209484537018,\n                \"page_views_total_log\" : 21.185010293923824\n              },\n            \"columns_name\" :\n              [\n                \"PC Filed\",\n                \"Owner'sHouse Street Name\",\n                \"Block\",\n                \"Site Fill\",\n                \"Existing Dwelling Units\",\n                \"Little e\",\n                \"Vertical Enlrgmt\",\n                \"Proposed Height\",\n                \"Other Description\",\n                \"BUILDING_CLASS\",\n                \"GIS_LATITUDE\",\n                \"Existing Occupancy\",\n                \"Proposed Occupancy\",\n                \"Owner's Business Name\",\n                \"City \",\n                \"GIS_COUNCIL_DISTRICT\",\n                \"Sprinkler\",\n                \"Standpipe\",\n                \"Bin #\",\n                \"Job Description\",\n                \"JOB_S1_NO\",\n                \"Existing Height\",\n                \"Proposed No. of Stories\",\n                \"Horizontal Enlrgmt\",\n                \"Curb Cut\",\n                \"Job #\",\n                \"Applicant Professional Title\",\n                \"Proposed Zoning Sqft\",\n                \"Owner's House Number\",\n                \"Existing Zoning Sqft\",\n                \"Total Est. Fee\",\n                \"Loft Board\",\n                \"Cluster\",\n                \"eFiling Filed\",\n                \"Approved\",\n                \"Building Type\",\n                \"Mechanical\",\n                \"Fuel Burning\",\n                \"Landmarked\",\n                \"Adult Estab\",\n                \"Street Frontage\",\n                \"Zoning Dist1\",\n                \"SIGNOFF_DATE\",\n                \"Assigned\",\n                \"Initial Cost\",\n                \"JOB_NO_GOOD_COUNT\",\n                \"Owner's Last Name\",\n                \"TOTAL_CONSTRUCTION_FLOOR_AREA\",\n                \"Latest Action Date\",\n                \"Applicant's Last Name\",\n                \"Applicant's First Name\",\n                \"Owner Type\",\n                \"Job Status Descrp\",\n                \"Doc #\",\n                \"ExistingNo. of Stories\",\n                \"GIS_BIN\",\n                \"Community - Board\",\n                \"Owner's First Name\",\n                \"Fully Permitted\",\n                \"Special District 2\",\n                \"Zip\",\n                \"Job Type\",\n                \"Fully Paid\",\n                \"Proposed Dwelling Units\",\n                \"Zoning Dist3\",\n                \"Pre- Filing Date\",\n                \"DOBRunDate\",\n                \"Fuel Storage\",\n                \"Enlargement SQ Footage\",\n                \"State\",\n                \"Fee Status\",\n                \"House #\",\n                \"City Owned\",\n                \"Boiler\",\n                \"Owner'sPhone #\",\n                \"Equipment\",\n                \"Job Status\",\n                \"SPECIAL_ACTION_DATE\",\n                \"Professional Cert\",\n                \"Lot\",\n                \"Paid\",\n                \"Zoning Dist2\",\n                \"Other\",\n                \"Plumbing\",\n                \"WITHDRAWAL_FLAG\",\n                \"Non-Profit\",\n                \"Fire Alarm\",\n                \"Street Name\",\n                \"SPECIAL_ACTION_STATUS\",\n                \"Borough\",\n                \"Fire Suppression\",\n                \"GIS_LONGITUDE\",\n                \"Applicant License #\",\n                \"GIS_NTA_NAME\",\n                \"Special District 1\",\n                \"GIS_CENSUS_TRACT\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"pc_filed\",\n                \"owner_shouse_street_name\",\n                \"block\",\n                \"site_fill\",\n                \"existing_dwelling_units\",\n                \"little_e\",\n                \"vertical_enlrgmt\",\n                \"proposed_height\",\n                \"other_description\",\n                \"building_class\",\n                \"gis_latitude\",\n                \"existing_occupancy\",\n                \"proposed_occupancy\",\n                \"owner_s_business_name\",\n                \"city_\",\n                \"gis_council_district\",\n                \"sprinkler\",\n                \"standpipe\",\n                \"bin__\",\n                \"job_description\",\n                \"job_s1_no\",\n                \"existing_height\",\n                \"proposed_no_of_stories\",\n                \"horizontal_enlrgmt\",\n                \"curb_cut\",\n                \"job__\",\n                \"applicant_professional_title\",\n                \"proposed_zoning_sqft\",\n                \"owner_s_house_number\",\n                \"existing_zoning_sqft\",\n                \"total_est__fee\",\n                \"loft_board\",\n                \"cluster\",\n                \"efiling_filed\",\n                \"approved\",\n                \"building_type\",\n                \"mechanical\",\n                \"fuel_burning\",\n                \"landmarked\",\n                \"adult_estab\",\n                \"street_frontage\",\n                \"zoning_dist1\",\n                \"signoff_date\",\n                \"assigned\",\n                \"initial_cost\",\n                \"job_no_good_count\",\n                \"owner_s_last_name\",\n                \"total_construction_floor_area\",\n                \"latest_action_date\",\n                \"applicant_s_last_name\",\n                \"applicant_s_first_name\",\n                \"owner_type\",\n                \"job_status_descrp\",\n                \"doc__\",\n                \"existingno_of_stories\",\n                \"gis_bin\",\n                \"community___board\",\n                \"owner_s_first_name\",\n                \"fully_permitted\",\n                \"special_district_2\",\n                \"zip\",\n                \"job_type\",\n                \"fully_paid\",\n                \"proposed_dwelling_units\",\n                \"zoning_dist3\",\n                \"pre__filing_date\",\n                \"dobrundate\",\n                \"fuel_storage\",\n                \"enlargement_sq_footage\",\n                \"state\",\n                \"fee_status\",\n                \"house__\",\n                \"city_owned\",\n                \"boiler\",\n                \"owner_sphone__\",\n                \"equipment\",\n                \"job_status\",\n                \"special_action_date\",\n                \"professional_cert\",\n                \"lot\",\n                \"paid\",\n                \"zoning_dist2\",\n                \"other\",\n                \"plumbing\",\n                \"withdrawal_flag\",\n                \"non_profit\",\n                \"fire_alarm\",\n                \"street_name\",\n                \"special_action_status\",\n                \"borough\",\n                \"fire_suppression\",\n                \"gis_longitude\",\n                \"applicant_license__\",\n                \"gis_nta_name\",\n                \"special_district_1\",\n                \"gis_census_tract\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Application Filed electronically, rather than manually\",\n                \"House Street Name of Property Owner\",\n                \"Tax block assigned by Department of Finance\",\n                \"Site Fill\",\n                \"Existing Dwelling Units\",\n                \"Hazardous\",\n                \"Vertical Enlrgmt\",\n                \"Proposed Height\",\n                \"Other Description\",\n                \"Building Class\",\n                \"Latitude\",\n                \"Existing Occupancy\",\n                \"Proposed Occupancy\",\n                \"Business Name of Property Owner\",\n                \"City \",\n                \"Council District\",\n                \"Sprinkler  Work Type? (X=Yes, Blank=No)\",\n                \"Standpipe Work Type? (X=Yes, Blank=No)\",\n                \"Number assigned by City Planning to a specific building\",\n                \"Job Description\",\n                \"JOB_S1_NO\",\n                \"Existing Height\",\n                \"Proposed No. of Stories\",\n                \"Horizontal Enlrgmt\",\n                \"Curb Cut  Work Type? (X=Yes, Blank=No)\",\n                \"Number assigned by DOB to Job Filing\",\n                \"Applicant's Professional Title\",\n                \"Proposed Zoning Sqft\",\n                \"House Number of Property Owner\",\n                \"Existing Zoning Sqft\",\n                \"Estimated fee of job\",\n                \"Loft Board\",\n                \"Cluster\",\n                \"Application Filed electronically, rather than manually\",\n                \"Date when job is approved\",\n                \"1-2-3 Family  or Other\",\n                \"Mechanical  Work Type? (X=Yes, Blank=No)\",\n                \"Fuel Burning  Work Type? (X=Yes, Blank=No)\",\n                \"L code indicates that the building has been assigned landmark status\",\n                \"Adult Estab\",\n                \"Street Frontage\",\n                \"Zoning Distr 1\",\n                \"Sign-off Date\",\n                \"Date when job is assigned to plan examiner\",\n                \" Estimated cost of job\",\n                \"Job No Good Count\",\n                \"Last Name of property owner\",\n                \"Total  Construction Floor Area\",\n                \"Latest status date\",\n                \"Last Name of Applicant\",\n                \"First Name of Applicant\",\n                \"Owner Type\",\n                \"Status code description\",\n                \"Document Number\",\n                \"ExistingNo. of Stories\",\n                \"BIN\",\n                \"3-digit identifier: Borough code = first position, last 2 = community board\",\n                \"First Name of property owner\",\n                \"Date when job is fully permitted\",\n                \"Special District 2\",\n                \"Zip\",\n                \"Job Type, based on DOB Job Code (NB-New Building, A1, A2, A3- Alterations 1-3, SG-Sign, etc.)\",\n                \"Date when job is paid and entered\",\n                \"Proposed Dwelling Units\",\n                \"Zoning Distr 3\",\n                \"Date when job is prefiled\",\n                \"Date when query is run and pushed to Open Data. Could be used to differentiate report dates.\",\n                \"Fuel Storage  Work Type? (X=Yes, Blank=No)\",\n                \"Enlargement SQ Footage\",\n                \"State\",\n                \"Type of Fee\",\n                \"House Number of Residence or Commercial Property\",\n                \"City Owned\",\n                \"Boiler  Work Type? (X=Yes, Blank=No)\",\n                \"Owner's  Phone #\",\n                \"Equipment  Work Type? (X=Yes, Blank=No)\",\n                \"DOB Status code of job (A-Pre Filed, I-Sign Off, P- Approved, R-Permit Entire) Complete List - http://www.nyc.gov/html/dob/downloads/pdf/bisjobstatus.pdf\",\n                \"Special Action Date\",\n                \"Job is Professionally Certified by Licensed Professional instead of having it reviewed by Department of Building's Plan Examiners\",\n                \"Tax lot assigned by Department of Finance\",\n                \"Date when job is paid\",\n                \"Zoning Distr 2\",\n                \"Other? (X=Yes, Blank=No)\",\n                \"Plumbing Work Type? (X=Yes, Blank=No)\",\n                \"Withdrawal Indicator\",\n                \"Non-Profit\",\n                \"Fire Alarm  Work Type? (X=Yes, Blank=No)\",\n                \"Street Name where Property is located\",\n                \"Special Action Status\",\n                \"1= Manhattan, 2= Bronx, 3 = Brooklyn, 4 = Queens, 5 = Staten Island\",\n                \"Fire Suppression  Work Type? (X=Yes, Blank=No)\",\n                \"Longitude\",\n                \"Number assigned to the skilled trade person/contractor or licensed professional\",\n                \"NTA Name\",\n                \"Special Distr 1\",\n                \"Census Tract\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"view\" : \"date\", \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" }\n              ],\n            \"download_count\" : 65650,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-06-22T18:23:35.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Housing & Development\",\n            \"domain_tags\" : [ \"buildings\", \"dob\", \"job\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Update_Automation\", \"value\" : \"Yes\" },\n                { \"key\" : \"Update_Date-Made-Public\", \"value\" : \"4/26/2013\" },\n                { \"key\" : \"Update_Update-Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Dataset-Information_Agency\",\n                  \"value\" : \"Department of Buildings (DOB)\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofnewyork.us\" },\n        \"permalink\" : \"https://data.cityofnewyork.us/d/ic3t-wcy2\",\n        \"link\" : \"https://data.cityofnewyork.us/Housing-Development/DOB-Job-Application-Filings/ic3t-wcy2\",\n        \"owner\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"5fuc-pqz2\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"NYC OpenData\"\n          }\n      }\n    ],\n  \"resultSetSize\" : 10000,\n  \"timings\" : { \"serviceMillis\" : 56, \"searchMillis\" : [ 5, 14 ] },\n  \"warnings\" : []\n}"), 
    timing = c(redirect = 0, namelookup = 1.4e-05, connect = 0, 
    pretransfer = 7e-05, starttransfer = 0.134867, total = 0.135652
    ), cache = new.env(parent = emptyenv())), class = "httr2_response")
