% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothers.R
\name{kernelMixedDensity}
\alias{kernelMixedDensity}
\title{Density with conditioning on discrete and continuous variables}
\usage{
kernelMixedDensity(
  x,
  by,
  xout = NULL,
  byout = NULL,
  weights = NULL,
  parallel = FALSE,
  cores = 1,
  preschedule = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector, matrix, or data frame containing observations. For density, the
points used to compute the density. For kernel regression, the points corresponding to
explanatory variables.}

\item{by}{A variable containing unique identifiers of discrete categories.}

\item{xout}{A vector or a matrix of data points with \code{ncol(xout) = ncol(x)}
at which the user desires to compute the weights, density, or predictions.
In other words, this is the requested evaluation grid.
If \code{NULL}, then \code{x} itself is used as the grid.}

\item{byout}{A variable containing unique identifiers of discrete categories
for the output grid (same points as \code{xout})}

\item{weights}{A numeric vector of observation weights (typically counts) to
perform weighted operations. If null, \code{rep(1, NROW(x))} is used. In
all calculations, the total number of observations is assumed to be the
sum of \code{weights}.}

\item{parallel}{Logical: if \code{TRUE}, parallelises the calculation over
the unique values of \code{by}. At this moment, supports only
\code{parallel::mclapply} (therefore, will not work on Windows).}

\item{cores}{Integer: the number of CPU cores to use. High core count = high RAM usage.
If the number of unique values of 'by' is less than the number of cores requested,
then, only \code{length(unique(by))} cores are used.}

\item{preschedule}{Logical: passed as \code{mc.preschedule} to \code{mclapply}.}

\item{...}{Passed to \code{kernelDensity}.}
}
\value{
A numeric vector of the density estimate of the same length as \code{nrow(xout)}.
}
\description{
Density with conditioning on discrete and continuous variables
}
\examples{
# Estimating 3 densities on something like a panel
set.seed(1)
n <- 200
x <- c(rnorm(n), rchisq(n, 4)/4, rexp(n, 1))
by <- rep(1:3, each = n)
xgrid <- seq(-3, 6, 0.1)
out <- expand.grid(x = xgrid, by = 1:3)
fhat <- kernelMixedDensity(x = x, xout = out$x, by = by, byout = out$by)
plot(xgrid, dnorm(xgrid)/3, type = "l", bty = "n", lty = 2, ylim = c(0, 0.35),
     xlab = "", ylab = "Density")
lines(xgrid, dchisq(xgrid*4, 4)*4/3, lty = 2, col = 2)
lines(xgrid, dexp(xgrid, 1)/3, lty = 2, col = 3)
for (i in 1:3) {
  lines(xgrid, fhat[out$by == i], col = i, lwd = 2)
  rug(x[by == i], col = i)
}
legend("top", c("00", "10", "01", "11"), col = 2:5, lwd  = 2)
}
