% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox_keselman.R
\name{wilcox_keselman}
\alias{wilcox_keselman}
\title{Wilcox and Keselman's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
wilcox_keselman(
  mainlm,
  gammapar = 0.2,
  B = 500L,
  p.adjust.method = "none",
  seed = NA,
  rqwarn = FALSE,
  matchWRS = FALSE,
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{gammapar}{A double value between 0 and 0.5 exclusive specifying the
quantile value \eqn{gamma}. Defaults to 0.2.}

\item{B}{An integer specifying the number of nonparametric bootstrap samples
to use to estimate standard error(s) of the quantile difference(s).
Defaults to \code{500L}.}

\item{p.adjust.method}{A character specifying the family-wise error rate
method to use in adjusting \eqn{p}-values (if it is a multiple linear
regression model). The value is passed to \code{\link[stats]{p.adjust}}.
By default no adjustment is made.}

\item{seed}{An integer specifying a seed to pass to
\code{\link[base]{set.seed}} for random number generation. This allows
reproducibility of bootstrap results. The value \code{NA}
results in not setting a seed.}

\item{rqwarn}{A logical specifying whether warnings generated by
\code{\link[quantreg]{rq.fit}} (such as 'Solution may be nonunique')
should be printed (\code{TRUE}) or suppressed (\code{FALSE}). Defaults
to \code{FALSE}.}

\item{matchWRS}{A logical specifying whether bootstrap samples should be
generated in the exact same manner as in the \code{qhomtv2} function in
\href{https://github.com/nicebread/WRS}{WRS} package. If \code{TRUE}, and
\code{seed} is set to \code{2} and \code{B} to \code{100} and
\code{p.adjust.method} to \code{"none"}, results will
be identical to those of the default settings of \code{qhomtv2}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the nonparametric test of
   \insertCite{Wilcox06;textual}{skedastic} for testing for heteroskedasticity
   in a simple linear regression model, and extends it to the multiple linear
   regression model.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
wilcox_keselman(mtcars_lm)

}
\references{
{\insertAllCited{}}
}
\seealso{
Rand R. Wilcox's package
   \href{https://github.com/nicebread/WRS}{WRS} on Github; in particular
   the functions \code{qhomt} and \code{qhomtv2}, which implement this
   method for simple and multiple linear regression respectively.
}
