% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simstudy-package.R
\name{distributions}
\alias{distributions}
\alias{normal}
\alias{poisson}
\alias{noZeroPoisson}
\alias{binary}
\alias{binomial}
\alias{uniform}
\alias{categorical}
\alias{gamma}
\alias{beta}
\alias{negBinomial}
\alias{nonrandom}
\alias{exponential}
\alias{mixture}
\title{Distributions for Data Definitions}
\arguments{
\item{formula}{Desired mean as a Number or an R expression for mean as a
String. Variables defined via \code{\link[=defData]{defData()}} and variables within the
parent environment (prefixed with \code{..}) can be used within the formula.
Functions from the parent environment can be used without a prefix.}

\item{variance}{Number. Default is \code{0}.}

\item{link}{String identifying the link function to be used. Default is
\code{identity}.}
}
\description{
This help file describes the distributions used for data creation in
\code{simstudy}.
}
\details{
For details about the statistical distributions please see
\link[stats:Distributions]{stats::distributions}, any non-statistical distributions will be
explained below. Required variables and expected pattern for each
distribution can be found in this table:\tabular{lllll}{
   \strong{name} \tab \strong{formula} \tab \strong{format} \tab \strong{variance} \tab \strong{link} \cr
   beta \tab mean \tab String or Number \tab dispersion value \tab identity or logit \cr
   binary \tab probability for 1 \tab String or Number \tab NA \tab identity, log, or logit \cr
   binomial \tab probability of success \tab String or Number \tab number of trials \tab identity, log, or logit \cr
   categorical \tab probabilities \tab \verb{p_1;p_2;..;p_n} \tab category labels: \verb{a;b;c} , \verb{50;130;20} \tab identity or logit \cr
   custom \tab name of function \tab String \tab arguments \tab identity \cr
   exponential \tab mean (lambda) \tab String or Number \tab NA \tab identity or log \cr
   gamma \tab mean \tab String or Number \tab dispersion value \tab identity or log \cr
   mixture \tab formula \tab \code{x_1 }|\code{p_1 + x_2}|\verb{p_2 ... x_n}|\code{ p_n} \tab NA \tab NA \cr
   negBinomial \tab mean \tab String or Number \tab dispersion value \tab identity or log \cr
   nonrandom \tab formula \tab String or Number \tab NA \tab NA \cr
   normal \tab mean \tab String or Number \tab variance \tab NA \cr
   noZeroPoisson \tab mean \tab String or Number \tab NA \tab identity or log \cr
   poisson \tab mean \tab String or Number \tab NA \tab identity or log \cr
   trtAssign \tab ratio \tab \verb{r_1;r_2;..;r_n} \tab stratification \tab identity or nonbalanced \cr
   uniform \tab range \tab \verb{from;to} \tab NA \tab NA \cr
   uniformInt \tab range \tab \verb{from;to} \tab NA \tab NA \cr
}
}
\section{Mixture}{
 The mixture distribution makes it possible to mix to
previously defined distributions/variables. Each variable that should be
part of the new distribution \verb{x_1,...,X_n} is assigned a probability
\verb{p_1,...,p_n}. For more information see
\href{https://www.rdatagen.net/post/adding-mixture-distributions-to-simstudy/}{rdatagen.net}.
}

\examples{
ext_var <- 2.9
def <- defData(varname = "external", formula = "3 + log(..ext_var)", variance = .5)
def
genData(5, def)
}
