% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listCaches.R
\name{listCaches}
\alias{listCaches}
\title{Show available caches.}
\usage{
listCaches(cacheSubDir = "")
}
\arguments{
\item{cacheSubDir}{Optional parameter to specify a subdirectory of the cache folder.}
}
\value{
\code{character} vector in which each element is the path to a file that 
        represents an available cache (within \code{getOption("RCACHE.DIR")})
}
\description{
Lists any cache files in the cache directory.
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
