% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{generators}
\alias{generators}
\alias{at}
\alias{from}
\alias{to}
\alias{from_to}
\alias{when_activated}
\title{Convenience Functions for Generators}
\usage{
at(...)

from(start_time, dist, arrive = TRUE)

to(stop_time, dist)

from_to(start_time, stop_time, dist, arrive = TRUE, every = NULL)

when_activated(n = 1)
}
\arguments{
\item{...}{a vector or multiple parameters of times at which to initiate an arrival.}

\item{start_time}{the time at which to launch the initial arrival.}

\item{dist}{a function modelling the interarrival times. It is supposed to be
an infinite source of values \code{>= 0} (e.g., \code{rexp} and the like). If
the function provided returns any negative value, the behaviour is undefined.}

\item{arrive}{if set to \code{TRUE} (default) the first arrival will be
generated at \code{start_time} and will follow \code{dist} from then on.
If set to \code{FALSE}, will initiate \code{dist} at \code{start_time}
(and the first arrival will most likely start at a time later than
\code{start_time}).}

\item{stop_time}{the time at which to stop the generator.}

\item{every}{repeat with this time cycle.}

\item{n}{number of arrivals to generate when activated.}
}
\value{
Returns a generator function (a closure).
}
\description{
These convenience functions facilitate the definition of generators of arrivals
for some common cases.
}
\details{
\code{\link{at}} generates arrivals at specific absolute times.

\code{\link{from}} generates inter-arrivals following a given distribution
with a specified start time.
union of the last two.

\code{\link{to}} generates inter-arrivals following a given
distribution with a specified stop time.

\code{\link{from_to}} is the union of \code{from} and \code{to}.

\code{\link{when_activated}} sets up an initially inactive generator
which generates \code{n} arrivals each time it is activated from any
trajectory using the activity \code{\link{activate}}.
}
\examples{
## common to all examples below
# some trajectory
t0 <- trajectory() \%>\%
  timeout(0)
# some distribution
distr <- function() runif(1, 1, 2)

# arrivals at 0, 1, 10, 30, 40 and 43
simmer() \%>\%
  add_generator("dummy", t0, at(0, c(1,10,30), 40, 43)) \%>\%
  run(100) \%>\%
  get_mon_arrivals()

# apply distribution starting at 5 (and no end)
simmer() \%>\%
  add_generator("dummy", t0, from(5, distr)) \%>\%
  run(10) \%>\%
  get_mon_arrivals()

# apply distribution until 5 (starting at 0)
simmer() \%>\%
  add_generator("dummy", t0, to(5, distr)) \%>\%
  run(10) \%>\%
  get_mon_arrivals()

# apply distribution from 8 to 16 h every 24 h:
simmer() \%>\%
  add_generator("dummy", t0, from_to(8, 16, distr, every=24)) \%>\%
  run(48) \%>\%
  get_mon_arrivals()

# triggering arrivals on demand from a trajectory
t1 <- trajectory() \%>\%
  activate("dummy")

simmer() \%>\%
  add_generator("dummy", t0, when_activated()) \%>\%
  add_generator("trigger", t1, at(2)) \%>\%
  run() \%>\%
  get_mon_arrivals()

}
\seealso{
\code{\link{add_generator}}.
}
