% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cosmic_signatures.R
\name{show_cosmic_sig_profile}
\alias{show_cosmic_sig_profile}
\title{Plot COSMIC Signature Profile}
\usage{
show_cosmic_sig_profile(
  sig_index = NULL,
  show_index = TRUE,
  sig_db = "legacy",
  ...
)
}
\arguments{
\item{sig_index}{a vector for signature index. "ALL" for all signatures.}

\item{show_index}{if \code{TRUE}, show valid indices.}

\item{sig_db}{default 'legacy', it can be 'legacy' (for COSMIC v2 'SBS'),
'SBS', 'DBS', 'ID' and 'TSB' (for SBS transcriptional strand bias signatures).
For more specific details, it can also be 'SBS_hg19', 'SBS_hg38',
'SBS_mm9', 'SBS_mm10', 'DBS_hg19', 'DBS_hg38', 'DBS_mm9', 'DBS_mm10'.
But the signature profile for different genome builds are basically same.}

\item{...}{other arguments passing to \link{show_sig_profile}.}
}
\value{
a \code{ggplot} object
}
\description{
Plot COSMIC Signature Profile
}
\examples{
show_cosmic_sig_profile()
show_cosmic_sig_profile(sig_db = "SBS")
show_cosmic_sig_profile(sig_index = 1:5)
show_cosmic_sig_profile(sig_db = "SBS", sig_index = c("10a", "17a"))

gg <- show_cosmic_sig_profile(sig_index = 1:5)
gg$aetiology
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
