% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_number_survey.R
\name{show_sig_number_survey}
\alias{show_sig_number_survey}
\title{Show Simplified Signature Number Survey}
\usage{
show_sig_number_survey(
  object,
  x = "rank",
  left_y = "cophenetic",
  right_y = "rss",
  left_name = left_y,
  right_name = toupper(right_y),
  left_color = "black",
  right_color = "red",
  left_shape = 16,
  right_shape = 18,
  shape_size = 4
)
}
\arguments{
\item{object}{a \code{Survey} object generated from \link{sig_estimate}, or
a \code{data.frame} contains at least rank columns and columns for
one measure.}

\item{x}{column name for x axis.}

\item{left_y}{column name for left y axis.}

\item{right_y}{column name for right y axis.}

\item{left_name}{label name for left y axis.}

\item{right_name}{label name for right y axis.}

\item{left_color}{color for left axis.}

\item{right_color}{color for right axis.}

\item{left_shape, right_shape, shape_size}{shape setting.}
}
\value{
a \code{ggplot} object
}
\description{
\link{sig_estimate} shows comprehensive rank survey generated by
\strong{NMF} package, sometimes
it is hard to consider all measures. Here provides a
one or two y-axis visualization method to help users determine
the optimal signature number (showing both
stability ("cophenetic") and error (RSS) at default).
Users can also set custom measures to show.
}
\examples{
\donttest{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
library(NMF)
cn_estimate <- sig_estimate(cn_tally_M$nmf_matrix,
  cores = 1, nrun = 5,
  verbose = TRUE
)

# Show two measures
show_sig_number_survey(cn_estimate)
# Show one measure
p <- show_sig_number_survey(cn_estimate, right_y = NULL)
p
p <- add_h_arrow(p, x = 4.1, y = 0.953, label = "selected number")
p

# Show data from a data.frame
show_sig_number_survey(cn_estimate$survey)
# Show other measures
head(cn_estimate$survey)
show_sig_number_survey(cn_estimate$survey,
  right_y = "dispersion",
  right_name = "dispersion"
)
show_sig_number_survey(cn_estimate$survey,
  right_y = "evar",
  right_name = "evar"
)
}
}
\seealso{
\link{sig_estimate} for estimating signature number for \link{sig_extract},
\link{show_sig_number_survey2} for more visualization method.
}
