% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_functions.R
\name{LPDS}
\alias{LPDS}
\title{Log Predictive Density Score}
\usage{
LPDS(mod, data_test, nsamp = 100)
}
\arguments{
\item{mod}{A \code{shrinkGPR} object representing the fitted Gaussian process regression model.}

\item{data_test}{Data frame with one row containing the covariates for the test set.
Variables in \code{data_test} must match those used in model fitting.}

\item{nsamp}{Positive integer specifying the number of posterior samples to use for the evaluation. Default is 100.}
}
\value{
A numeric value representing the log predictive density score for the test dataset.
}
\description{
\code{LPDS} calculates the log predictive density score for a fitted \code{shrinkGPR} model using a test dataset.
}
\details{
The log predictive density score is a measure of model fit that evaluates how well the model predicts unseen data.
It is computed as the log of the marginal predictive density of the observed responses.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Simulate data
  set.seed(123)
  torch::torch_manual_seed(123)
  n <- 100
  x <- matrix(runif(n * 2), n, 2)
  y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
  data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

  # Fit GPR model
  res <- shrinkGPR(y ~ x1 + x2, data = data)

  # Calculate true y value and calculate LPDS at specific point
  x1_new <- 0.8
  x2_new <- 0.5
  y_true <- sin(2 * pi * x1_new)
  data_test <- data.frame(y = y_true, x1 = x1_new, x2 = x2_new)
  LPDS(res, data_test)
  }
}
}
