% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{deviance.initgmf}
\alias{deviance.initgmf}
\alias{AIC.initgmf}
\alias{BIC.initgmf}
\title{Compute deviance, AIC and BIC of an initialized GMF model}
\usage{
\method{deviance}{initgmf}(object, ..., normalize = FALSE)

\method{AIC}{initgmf}(object, ..., k = 2)

\method{BIC}{initgmf}(object, ...)
}
\arguments{
\item{object}{an object of class \code{initgmf}}

\item{...}{further arguments passed to or from other methods}

\item{normalize}{if \code{TRUE}, normalize the result using the null-deviance}

\item{k}{the penalty parameter to be used for AIC; the default is \code{k = 2}}
}
\value{
The value of the deviance extracted from a \code{initgmf} object.
}
\description{
Compute deviance, AIC and BIC of an initialized GMF object
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the GMF deviance, AIC and BIC
deviance(init)
AIC(init)
BIC(init)

}
\seealso{
\code{\link{deviance.sgdgmf}}, \code{\link{AIC.sgdgmf}} and \code{\link{AIC.sgdgmf}}.
}
