% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentopics.R
\docType{data}
\name{PicaultRenault}
\alias{PicaultRenault}
\title{Picault-Renault lexicon}
\format{
A \link[data.table:data.table]{data.table::data.table} object.
}
\source{
\url{http://www.cbcomindex.com/lexicon.php}
}
\usage{
PicaultRenault
}
\description{
The Picault-Renault lexicon, specialized in the analysis of
central bank communication. The lexicon identifies a large number of n-grams
and gives their probability to belong to six categories:
\itemize{
\item Monetary Policy - accommodative
\item Monetary Policy - neutral
\item Monetary Policy - restrictive
\item Economic Condition - negative
\item Economic Condition - neutral
\item Economic Condition - positive
}
}
\examples{
head(PicaultRenault)

}
\references{
Picault, M. & Renault, T. (2017). Words are not all created
equal: A new measure of ECB
communication. \emph{Journal of
International Money and Finance}, 79, 136--156.
\doi{10.1016/j.jimonfin.2017.09.005}
}
\seealso{
\code{\link[=compute_PicaultRenault_scores]{compute_PicaultRenault_scores()}}
}
\keyword{datasets}
