% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{actions_mousedown}
\alias{actions_mousedown}
\alias{actions_mouseup}
\alias{actions_mousemove}
\title{Press, release or move the mouse}
\usage{
actions_mousedown(
  button = c("left", "right", "middle"),
  width = NULL,
  height = NULL,
  pressure = NULL,
  tangential_pressure = NULL,
  tilt_x = NULL,
  tilt_y = NULL,
  twist = NULL,
  altitude_angle = NULL,
  azimuth_angle = NULL
)

actions_mouseup(
  button = c("left", "right", "middle"),
  width = NULL,
  height = NULL,
  pressure = NULL,
  tangential_pressure = NULL,
  tilt_x = NULL,
  tilt_y = NULL,
  twist = NULL,
  altitude_angle = NULL,
  azimuth_angle = NULL
)

actions_mousemove(
  x,
  y,
  duration = NULL,
  origin = c("viewport", "pointer"),
  width = NULL,
  height = NULL,
  pressure = NULL,
  tangential_pressure = NULL,
  tilt_x = NULL,
  tilt_y = NULL,
  twist = NULL,
  altitude_angle = NULL,
  azimuth_angle = NULL
)
}
\arguments{
\item{button}{The mouse button to press.}

\item{width}{The 'width' of the click, a number.}

\item{height}{The 'height' of the click, a number.}

\item{pressure}{The amount of pressure to apply to the click: a number
between 0 and 1.}

\item{tangential_pressure}{A number between 0 and 1.}

\item{tilt_x}{A whole number between -90 and 90.}

\item{tilt_y}{A whole number between -90 and 90.}

\item{twist}{A whole number between 0 and 359.}

\item{altitude_angle}{A number between 0 and \code{pi/2}.}

\item{azimuth_angle}{A number between 0 and \code{2*pi}.}

\item{x}{The x coordinate of the mouse movement.}

\item{y}{The y coordinate of the mouse movement.}

\item{duration}{The duration of the mouse movement, in seconds.}

\item{origin}{The point from which \code{x} and \code{y} are measured. Can be a
\code{WebElement} object, in which case \code{x} and \code{y} are measured from the
center of the element.}
}
\value{
A \code{selenium_action} object.
}
\description{
Mouse actions to be passed into \code{\link[=actions_stream]{actions_stream()}}. \code{actions_mousedown()}
represents pressing a button on the mouse, while \code{actions_mouseup()}
represents releasing a button. \code{actions_mousemove()} represents moving the
mouse.
}
\examples{
actions_stream(
  actions_mousedown("left", width = 1, height = 1, pressure = 0.5),
  actions_mouseup("left", width = 100, height = 50, pressure = 1),
  actions_mousemove(x = 1, y = 1, duration = 1, origin = "pointer")
)

}
