% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_prep.R
\name{expand_q_matrix}
\alias{expand_q_matrix}
\title{Function to expand an existing q_matrix to a number of concealed states}
\usage{
expand_q_matrix(q_matrix, num_concealed_states, diff.conceal = FALSE)
}
\arguments{
\item{q_matrix}{\code{q_matrix} with only transitions between observed states.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{diff.conceal}{Boolean stating if the concealed states should be
different. E.g. that the transition rates for the concealed
states are different from the transition rates for the examined states.
Normally it should be \code{FALSE} in order to avoid having a huge number of
parameters.}
}
\value{
updated q matrix
}
\description{
Function to expand an existing q_matrix to a number of concealed states
}
\note{
This is highly similar to \code{\link[=q_doubletrans]{q_doubletrans()}}.
}
