% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinusoid.R
\name{sinusoid}
\alias{sinusoid}
\title{Plot a Sinusoid}
\usage{
sinusoid(amplitude, frequency, phase, ...)
}
\arguments{
\item{amplitude}{the amplitude of the sinsuoid (its maximum value).}

\item{frequency}{the frequency of the sinusoid in 0 to 2\eqn{\pi} (number of
cycles).}

\item{phase}{the phase of the sinusoid (location of the peak).}

\item{\dots}{additional arguments passed to the plot.}
}
\description{
Plots a sinusoid over 0 to 2\eqn{\pi}.
}
\details{
Sinusoidal curves are useful for modelling seasonal data. A sinusoid is
plotted using the equation: \eqn{A\cos(ft-P), t=0,\ldots,2 \pi}, where
\eqn{A} is the amplitude, \eqn{f} is the frequency, \eqn{t} is time and
\eqn{P} is the phase.
}
\examples{
sinusoid(amplitude=1, frequency=1, phase=1)

}
\references{
Barnett, A.G., Dobson, A.J. (2010) \emph{Analysing Seasonal
Health Data}. Springer.
}
\author{
Adrian Barnett \email{a.barnett@qut.edu.au}
}
