% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcelling.R
\name{parcelling}
\alias{parcelling}
\title{Parcelling}
\usage{
parcelling(
  xf,
  xnf,
  yf,
  probs = seq(0, 1, 0.25),
  alpha = rep(1, length(probs) - 1)
)
}
\arguments{
\item{xf}{The matrix of financed clients' characteristics to be used in the scorecard.}

\item{xnf}{The matrix of not financed clients' characteristics to be used in the scorecard (must be the same in the same order as xf!).}

\item{yf}{The matrix of financed clients' labels}

\item{probs}{The sequence of quantiles to use to make scorebands (see the vignette).}

\item{alpha}{The user-defined coefficients to use with Parcelling (see the vignette).}
}
\value{
List containing the model using financed clients only and the model produced using the Parcelling method.
}
\description{
This function performs Reject Inference using the Parcelling technique. Note that this technique is theoretically good in the MNAR framework although coefficients must be chosen a priori.
}
\details{
This function performs the Parcelling method on the data. When provided with labeled observations \eqn{(x^\ell,y)}, it first fits the logistic regression model \eqn{p_\theta} of
\eqn{x^\ell} on \eqn{y}, then labels the unlabelled samples \eqn{x^{u}} with the observed bad rate in user-defined classes of predicted probabilities of \eqn{p_\theta} reweighted using user-supplied weights, i.e. \eqn{\hat{y}^{u} = \alpha_k T(k)} where \eqn{k} denotes the group (which depends on \eqn{p_\theta}) and T(k) the observed bad rate of labeled observations in this group.
It then refits a logistic regression model \eqn{p_\eta} on the whole sample.
}
\examples{
# We simulate data from financed clients
df <- generate_data(n = 100, d = 2)
xf <- df[, -ncol(df)]
yf <- df$y
# We simulate data from not financed clients (MCAR mechanism)
xnf <- generate_data(n = 100, d = 2)[, -ncol(df)]
parcelling(xf, xnf, yf)
}
\references{
Enea, M. (2015), speedglm: Fitting Linear and Generalized Linear Models to Large Data Sets, \url{https://CRAN.R-project.org/package=speedglm}
Ehrhardt, A., Biernacki, C., Vandewalle, V., Heinrich, P. and Beben, S. (2018), Reject Inference Methods in Credit Scoring: a rational review,
}
\seealso{
\code{glm}, \code{speedglm}
}
\author{
Adrien Ehrhardt
}
\keyword{credit}
\keyword{inference}
\keyword{reject}
\keyword{réintégration}
\keyword{scorecard}
\keyword{scoring}
