% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_plot}
\alias{woebin_plot}
\title{WOE Binning Visualization}
\usage{
woebin_plot(bins, x = NULL, title = NULL, show_iv = TRUE,
  line_value = "posprob", ...)
}
\arguments{
\item{bins}{A list of data frames. Binning information generated by \code{woebin}.}

\item{x}{Name of x variables. Defaults to NULL. If x is NULL, then all columns except y are counted as x variables.}

\item{title}{String added to the plot title. Defaults to NULL.}

\item{show_iv}{Logical. Defaults to TRUE, which means show information value in the plot title.}

\item{line_value}{The value displayed as line. Accepted values are 'posprob' and 'woe'. Defaults to positive probability.}

\item{...}{Additional parameters}
}
\value{
A list of binning graphics.
}
\description{
\code{woebin_plot} create plots of count distribution and positive probability for each bin. The binning informations are generates by  \code{woebin}.
}
\examples{
# Load German credit data
data(germancredit)

# Example I
bins1 = woebin(germancredit, y="creditability", x="credit.amount")

p1 = woebin_plot(bins1)
print(p1)

# modify line value
p1_w = woebin_plot(bins1, line_value = 'woe')
print(p1_w)

# modify colors
p1_c = woebin_plot(bins1, line_color='#FC8D59', bar_color=c('#FFFFBF', '#99D594'))
print(p1_c)

# show iv, line value, bar value
p1_iv = woebin_plot(bins1, show_iv = FALSE)
print(p1_iv)
p1_lineval = woebin_plot(bins1, show_lineval = FALSE)
print(p1_lineval)
p1_barval  = woebin_plot(bins1, show_barval = FALSE)
print(p1_barval)

\donttest{
# Example II
bins = woebin(germancredit, y="creditability")
plotlist = woebin_plot(bins)
print(plotlist$credit.amount)

# # save binning plot
# for (i in 1:length(plotlist)) {
#   ggplot2::ggsave(
#      paste0(names(plotlist[i]), ".png"), plotlist[[i]],
#      width = 15, height = 9, units="cm" )
#   }
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_adj}}
}
