% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{step_taxonomy}
\alias{step_taxonomy}
\alias{tidy.step_taxonomy}
\title{Taxonomic clades feature generator}
\usage{
step_taxonomy(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  rank = NULL,
  res = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("taxonomy")
)

\method{tidy}{step_taxonomy}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \code{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{rank}{The desired ranks, a combinaison of \code{"kingdom"}, \code{"phylum"},
\code{"class"}, \code{"order"}, \code{"family"}, \code{"genus"}, \code{"species"}, or \code{"strain"}. See
\code{\link[yatah:get_clade]{yatah::get_clade()}} for more details.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{keep_original_cols}{A logical to keep the original variables in
the output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_taxonomy} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Extract clades from a lineage, as defined in the \code{{yatah}} package.
}
\examples{
\dontshow{if (rlang::is_installed("yatah")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("cheese_taxonomy")
rec <-
  cheese_taxonomy \%>\%
  select(asv, lineage) \%>\%
  recipe(~ .) \%>\%
  step_taxonomy(lineage, rank = c("order", "genus")) \%>\%
  prep()
rec
tidy(rec, 1)
bake(rec, new_data = NULL)
\dontshow{\}) # examplesIf}
}
\author{
Antoine Bichat
}
