% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{process_phase}
\alias{process_phase}
\title{Process Phase Variable}
\usage{
process_phase(.df, .phase, phase_levels, phase_labels)
}
\arguments{
\item{.df}{A data frame containing the data to be processed. Must contain a column
specified by \code{.phase}.}

\item{.phase}{The name of the column in \code{.df} that contains the phase variable.}

\item{phase_levels}{(Optional) A vector of values indicating the order of phase
levels. This is used to set the factor levels of the phase
variable.}

\item{phase_labels}{(Optional) A vector of labels corresponding to the phase
levels. These labels are used in annotations. If not provided,
the \code{phase_levels} are used as labels.}
}
\value{
The input data frame \code{.df} with the phase variable processed as a factor
with the specified levels and labels.
}
\description{
This is an internal helper function used by \code{raw_plot} and \code{mixed_model_analysis}
to process the phase variable in the input data frame. It sets the factor levels
and labels of the phase variable based on the provided \code{phase_levels} and
\code{phase_labels} parameters.
}
\keyword{internal}
