% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_enrich_internal.R
\name{pathway_enrich_internal}
\alias{pathway_enrich_internal}
\title{Internal - Pathway enrichment for cellWeighted_Foldchanges and bulk gene list}
\usage{
pathway_enrich_internal(
  DEGs,
  theSpecies,
  scMappR_vals,
  background_genes,
  output_directory,
  plot_names,
  number_genes = -9,
  newGprofiler = FALSE,
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{DEGs}{Differentially expressed genes (gene_name, padj, log2fc).}

\item{theSpecies}{Human, mouse, or a character that is compatible with g:ProfileR.}

\item{scMappR_vals}{cell weighted Fold-changes of differentially expressed genes.}

\item{background_genes}{A list of background genes to test against.}

\item{output_directory}{Path to the directory where files will be saved.}

\item{plot_names}{Names of output.}

\item{number_genes}{Number of genes to if there are many, many DEGs.}

\item{newGprofiler}{Whether to use g:ProfileR or gprofiler2 (T/F).}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
List with the following elements:
\item{BPs}{Enriched biological pathways for each cell-type.}
\item{TFs}{Enriched transcription factors for each cell-type.}
}
\description{
This function completes pathway enrichment of cellWeighted_Foldchanges and bulk gene list.
}
\details{
Internal: Pathway analysis of differentially expressed genes (DEGs) and cell weighted Fold-changes (cellWeighted_Foldchanges) for each cell-type. Returns .RData objects of differential analysis as well as plots of the top bulk pathways.
It is a wrapper for making barplots, bulk pathway analysis, and gProfiler_cellWeighted_Foldchange.
}
\examples{
\donttest{

data(PBMC_example)
bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in
case_grep <- "_female"
control_grep <- "_male"
max_proportion_change <- 10
print_plots <- FALSE
theSpecies <- "human"
toOut <- scMappR_and_pathway_analysis(bulk_normalized, odds_ratio_in, 
                                      bulk_DE_cors, case_grep = case_grep,
                                      control_grep = control_grep, rda_path = "", 
                                      max_proportion_change = 10, print_plots = TRUE, 
                                       plot_names = "tst1", theSpecies = "human", 
                                       output_directory = "tester",
                                       sig_matrix_size = 3000, up_and_downregulated = FALSE, 
                                       internet = FALSE)

}
}
