% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_glue}
\alias{lbl_glue}
\title{Label chopped intervals using the {glue} package}
\usage{
lbl_glue(
  label,
  fmt = NULL,
  single = NULL,
  first = NULL,
  last = NULL,
  raw = FALSE,
  ...
)
}
\arguments{
\item{label}{A glue string passed to \code{\link[glue:glue]{glue::glue()}}.}

\item{fmt}{String or function. A format for break endpoints.}

\item{single}{Glue string: label for singleton intervals. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{first}{Glue string: override label for the first category. Write e.g.
\code{first = "<{r}"} to create a label like \code{"<18"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{last}{String: override label for the last category. Write e.g.
\code{last = ">{l}"} to create a label like \code{">65"}. See \code{\link[=lbl_glue]{lbl_glue()}}
for details.}

\item{raw}{Logical. Always use raw \code{breaks} in labels, rather than e.g.
quantiles or standard deviations?}

\item{...}{Further arguments passed to \code{\link[glue:glue]{glue::glue()}}.}
}
\value{
A function that creates a vector of labels.
}
\description{
Use \code{"{l}"} and \code{"{r}"} to show the left and right endpoints of the intervals.
}
\details{
The following variables are available in the glue string:
\itemize{
\item \code{l} is a character vector of left endpoints of intervals.
\item \code{r} is a character vector of right endpoints of intervals.
\item \code{l_closed} is a logical vector. Elements are \code{TRUE} when the left
endpoint is closed.
\item \code{r_closed} is a logical vector, \code{TRUE} when the right endpoint is closed.
}

Endpoints will be formatted by \code{fmt} before being passed to \code{glue()}.
}
\section{Formatting endpoints}{


If \code{fmt} is not \code{NULL} then it is used to format the endpoints. If \code{fmt} is a
string then numeric endpoints will be formatted by \code{sprintf(fmt, breaks)};
other endpoints, e.g. Date objects, will be formatted by \code{format(breaks, fmt)}.

If \code{fmt} is a function, it should take a vector of numbers (or other objects
that can be used as breaks) and return a character vector. It may be helpful
to use functions from the \code{{scales}} package, e.g. \code{\link[scales:label_number]{scales::label_comma()}}.
}

\examples{
tab(1:10, c(1, 3, 3, 7),
    label = lbl_glue("{l} to {r}", single = "Exactly {l}"))

tab(1:10 * 1000, c(1, 3, 5, 7) * 1000,
    label = lbl_glue("{l}-{r}", fmt = function(x) prettyNum(x, big.mark=',')))

# reproducing lbl_intervals():
interval_left <- "{ifelse(l_closed, '[', '(')}"
interval_right <- "{ifelse(r_closed, ']', ')')}"
glue_string <- paste0(interval_left, "{l}", ", ", "{r}", interval_right)
tab(1:10, c(1, 3, 3, 7), label = lbl_glue(glue_string, single = "{{{l}}}"))

}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_discrete}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
