% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{fillet}
\alias{fillet}
\title{Chop data precisely (for programmers)}
\usage{
fillet(x, breaks, labels = lbl_intervals(), left = TRUE, close_end = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{breaks}{A numeric vector of cut-points or a function to create
cut-points from \code{x}.}

\item{labels}{A character vector of labels or a function to create labels.}

\item{left}{Logical. Left-closed breaks?}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}
}
\value{
\code{fillet()} returns a \code{\link{factor}} of the same length as \code{x}, representing
the intervals containing the value of \code{x}.
}
\description{
Chop data precisely (for programmers)
}
\details{
\code{fillet()} calls \code{\link[=chop]{chop()}} with \code{extend = FALSE} and \code{drop = FALSE}. This
ensures that you get only the \code{breaks} and \code{labels} you ask for. When
programming, consider using \code{fillet()} instead of \code{chop()}.
}
\examples{
fillet(1:10, c(2, 5, 8))
}
\seealso{
Other chopping functions: 
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()}
}
\concept{chopping functions}
