% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R
\name{chop_n}
\alias{chop_n}
\alias{brk_n}
\title{Chop into fixed-sized groups}
\usage{
chop_n(x, n, ..., close_end = TRUE)

brk_n(n)
}
\arguments{
\item{x}{A numeric vector.}

\item{n}{Integer: number of elements in each interval.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{close_end}{Passed to \code{\link[=chop]{chop()}}.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
\code{chop_n()} creates intervals containing a fixed number of elements. One
interval may have fewer elements.
}
\details{
Note that \code{chop_n()} sets \code{close_end = TRUE} by default.

Groups may be larger than \code{n}, if there are too many duplicated elements
in \code{x}. If so, a warning is given.
}
\examples{
table(chop_n(1:10, 5))

table(chop_n(1:10, 4))

# too many duplicates
x <- rep(1:2, each = 3)
chop_n(x, 2)

}
\seealso{
Other chopping functions: 
\code{\link{chop_mean_sd}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
