% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataBeta.R
\docType{data}
\name{dataBeta}
\alias{dataBeta}
\title{Simulated dataset Under Two Fold Subarea level model with Beta distribution.}
\format{
A data frame with 90 rows and 6 columns:
\describe{
\item{y}{Direct estimation of subarea mean \eqn{y_{ij}}}
\item{X1}{Auxiliary variable of \eqn{X_{ij1}}}
\item{X2}{Auxiliary variable of \eqn{X_{ij2}}}
\item{codearea}{Index that describes the code relating to area for each subarea}
\item{w}{Unit proportion on each subarea or weight \eqn{w_{ij}}}
\item{vardir}{Sampling variance of direct estimator \eqn{y_{ij}}}
}
}
\usage{
dataBeta
}
\description{
A dataset to simulate Small Area Estimation using Hierarchical Bayesian method under Two Fold Subarea level model with Beta distribution on variable interest.

This data is generated by these following steps:
\enumerate{
\item Generate auxiliary variable \eqn{X_{ij1},X_{ij2}}, sampling error \eqn{e_{ij}},subarea random effect \eqn{u_{ij}}, area random effect \eqn{v_{i}}, and weight or proportions of unit \eqn{w_{ij}}
\itemize{
\item Generate auxiliary variable on subarea level \eqn{X_{ij1}}~ \eqn{U(0,1)}
\item Generate auxiliary variable on subarea level \eqn{X_{ij2}}~\eqn{N(0,1)}
\item Setting coefficient \eqn{\beta_{0}=\beta_{1}=\beta_{2} =0.5}
\item Generate area random effect \eqn{v_{i}} ~ \eqn{N(0,1)}
\item Generate subarea random effect \eqn{u_{ij}}~\eqn{N(0,1)}
\item Calculate target parameter \eqn{\mu_{ij}=\beta_{0} +\beta_{1}x_{ij1} +\beta_{2}x_{ij2}+v_{i}+u_{ij}}
\item Generate constant for Beta parameter \eqn{\pi_{ij}}~ \eqn{Gamma(1,0.5)}
\item Calculate Beta parameter \eqn{A=\mu_{ij}\pi_{ij}} and \eqn{A=(1-\mu_{ij})\pi_{ij}}
\item Generate direct estimator \eqn{y_{ij}}~ \eqn{Beta(A,B)}
\item Generate weight on each subarea \eqn{w_{ij}}~\eqn{U(0.2,0.7)}
}
\item Direct estimation (\eqn{y_{ij}}), Auxiliary variables \eqn{X_{ij1}},\eqn{X_{ij2}}, vardir, codearea, and weight \eqn{w_{ij}} are combined in a dataframe called dataBeta
}
}
\keyword{datasets}
