% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fill_na.R
\name{ts_fill_na}
\alias{ts_fill_na}
\title{Fill NA values in a raster time series}
\usage{
ts_fill_na(x_list_fill, maskvalues = NULL, verbose = FALSE, ...)
}
\arguments{
\item{x_list_fill}{a list of raster objects.}

\item{maskvalues}{numeric, a vector of values to be set to NA before the masking.}

\item{verbose}{(Optional) logical. If \code{TRUE} outputs progress. Default is \code{FALSE}.}

\item{...}{additional arguments to be passed on to  \link[raster]{approxNA}. Of particular interest is the \code{rule} argument which defines how first and last cells are dealt with.}
}
\value{
A list of rasters with NAs filled.
}
\description{
Fill NA values in a raster time series
}
\details{
Loads all layers of a specific bands into a stack and uses \link[raster]{approxNA} to fill the NAs if possible. Note that the procedure requires the entire list of raster layery for each band to be be stacked. It is therefore very memory intensive and likely to fail for very large time series.
}
\examples{
\donttest{

#Setup
 library(rtsVis)
x_list <- MODIS_SI_ds[seq(1,length(MODIS_SI_ds),15)]   #A list of raster objects

#Fill NAs
x_list_filled <- ts_fill_na(x_list) 
}
}
\author{
Johannes Mast
}
