% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsComposite.R
\name{rsComposite}
\alias{rsComposite}
\title{rsComposite}
\usage{
rsComposite(x, x.dates, obs.dates, comp.method = "closest",
  temporal.buffer = NULL)
}
\arguments{
\item{x}{Object of class \emph{RasterStack} or \emph{RasterBrick}.}

\item{x.dates}{Object of class \emph{Date} with \emph{x} observation dates.}

\item{obs.dates}{Object of class \emph{Date} with reference dates.}

\item{comp.method}{One of "closest" or "phenological". The default is "closest".}

\item{temporal.buffer}{Search buffer (expressed in days). The default is NULL.}
}
\value{
A \emph{list}.
}
\description{
{Phenological and date driven Pixel Based Compositing (PBC).}
}
\details{
{The function uses a multi-layer raster object to build a composite for a reference date which
corresponds to the median of \emph{obs.dates}. Moreover,the function estimates the Median Absolute Deviation
(MAD) of \emph{obs.dates} which determines the temporal buffer that is used to search for usable data. As an
alternative, \emph{temporal.buffer} can be specified manually and will be required if \emph{obs.dates} consists
of a single value. The user can also specify how the compositing should be done. \emph{comp.method} can be set to:
#' \itemize{
 \item{\emph{closest} - Selects pixels from layers with the closest possible date.}
 \item{\emph{phenological} - Selects pixels from layers with the closest Day of the Year (DoY).}}
The final output of \emph{rsComposite} is a list consisting of:
#' \itemize{
 \item{\emph{composite} - Final image composite}
 \item{\emph{dates} - Temporal composition of the composite reporting on the julian day (origin is "1970-01-01").}
 \item{\emph{pixel.count} - pixel count of unique values in \emph{dates}. Additionally, it reports on NA values.}
 \item{\emph{pixel.count.plot} - Plot with relative frequency of pixels per date extracted from \emph{pixel.count}.}
 \item{\emph{target.date} - Reference date used during compositing.}
 \item{\emph{temporal.buffer} - Temporal buffer used during compositing.}}
 If \emph{pheno2} is used, for each pixel, the function will estimate a weighted
 mean of the clear pixels within the temporal buffer. The weights represent the
 inverse time difference between the target and the available dates giver higher
 weights to small differences.}
}
\examples{
\dontrun{

 require(raster)

 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)
 r.stk <- stack(r.stk, r.stk, r.stk) # dummy files for the example

 # raster dates
 file.name <- names(r.stk)
 x.dates <- as.Date(paste0(substr(file.name, 2, 5), '-',
 substr(file.name, 7, 8), '-', substr(file.name, 10, 11)))

 # target date
 obs.dates = as.Date("2013-06-01")

 # build composite
 r.comp <- rsComposite(r.stk, x.dates, obs.dates, comp.method="closest", temporal.buffer=90)

}
}
\seealso{
\code{\link{imgInt}} \code{\link{dataQuery}}
}
