% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictResources.R
\name{predictResources}
\alias{predictResources}
\title{predictResources}
\usage{
predictResources(x, y, z, env.data = NULL)
}
\arguments{
\item{x}{Object of class \emph{data.frame} with environmental variables for presence samples.}

\item{y}{Object of class \emph{data.frame} with environmental variables for background samples.}

\item{z}{\emph{Numeric} or \emph{character} vector with sample region labels. If missing, \emph{x} is assumed as being one region.}

\item{env.data}{Object of class \emph{RasterStack} or \emph{RasterBrick} with environmental variables in \emph{x} and \emph{y}.}
}
\value{
A \emph{list}.
}
\description{
Spatially stratified predictive modeling of resource suitability based on presence/absence samples.
}
\details{
{Modeling of resource suitability using animal movement data following the method of Remelgado et al (2017). Each
unique label in \emph{z} is kept for validation while the remaining samples are used for training. Then, the function evaluates
the performance of this model reporting (internally) on the number of true positives, false positives and the number of cases for
both presences and absences. Once all sample regions are used for validation, the reported values are summed and used to derive a
F1-measure. The F1-measure is estimated as \emph{2 * (P * R) / (P + R)} where \emph{P} is the Precision (ratio of true positives
within the number of predicted values) and \emph{R} is the Recall (ratio of true positives within the number of validation samples).
As a consequence, rather than reporting on an average performance, the final performance assessment reported by \emph{predictResources}
depicts an objective picture on how the model performed among the different sets sample regions. This metric is provided for presences
(\emph{x}) and absences ({\emph{y}}) separately informing on the stability of the model. This analysis is performed using a Random Forest
model as provided within the \code{\link[caret]{train}} function of the caret package. The final predictive model is then derived with all
samples. The output of the function is a list object consisting of:
\itemize{
 \item{\emph{f1} - \emph{data.frame} with final F1-measure for presences and absences.}
 \item{\emph{overal..validation} - \emph{data.frame} with region identifiers and validation sample count at each iteration.}
 \item{\emph{sample.validation} -:Logical vector with the validation of each observation in \emph{x}.}
 \item{\emph{iteration.models} - List of models estimated at each iteration.}
 \item{\emph{final.model} - Final predictive model based on all samples.}
 \item{\emph{probabilities} - Predicted probability image. Given if \emph{env.data} is set.}}}
}
\examples{
\dontrun{

 require(raster)

 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)

 # read movement data
 data(shortMove)

 # observation time
 obs.time <- strptime(paste0(shortMove@data$date, ' ', shortMove@data$time),
 format="\%Y/\%m/\%d \%H:\%M:\%S")

 # remove redundant samples
 shortMove <- moveReduce(shortMove, r.stk, obs.time)$points

 # retrieve remote sensing data for samples
 rsQuery <- extract(r.stk, shortMove)

 # identify unique sample regions
 label <- labelSample(shortMove, r.stk, agg.radius=30)

 # select background samples
 bSamples <- backSample(shortMove, r.stk, label, sampling.method='pca')

 # derive model predictions
 out <- predictResources(rsQuery, bSamples@data, label, env.data=r.stk)

}
}
\references{
\href{10.1002/rse2.70}{Remelgado, R., Leutner, B., Safi, K., Sonnenschein, R., Kuebert, C. and Wegmann, M. (2017), Linking animal movement and remote sensing - mapping resource suitability from a remote sensing perspective. Remote Sens Ecol Conserv.}
}
\seealso{
\code{\link{sampleMove}} \code{\link{labelSample}} \code{\link{backSample}} \code{\link[caret]{train}}
}
