% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gap_numeric}
\alias{gap_numeric}
\title{Create YAML string for NumericGap object}
\usage{
gap_numeric(
  solution,
  tolerance = 0,
  tolerance_type = "absolute",
  points = 1,
  response_identifier = NULL,
  include_lower_bound = TRUE,
  include_upper_bound = TRUE,
  expected_length = size_gap(solution),
  placeholder = NULL
)
}
\arguments{
\item{solution}{A numeric value; contains right answer for this numeric
entry.}

\item{tolerance}{A numeric value, optional; specifies the value for up and
low boundaries of tolerance rate for candidate answer. Default is 0.}

\item{tolerance_type}{A character string, optional; specifies tolerance mode;
possible values:"exact", "absolute" (by default), "relative".}

\item{points}{A numeric value, optional; the number of points for this gap.
Default is 1.}

\item{response_identifier}{A character string, optional; an identifier for
the answer.}

\item{include_lower_bound}{A boolean, optional; specifies whether or not the
lower bound is included in tolerance rate.}

\item{include_upper_bound}{A boolean, optional; specifies whether or not the
upper bound is included in tolerance rate.}

\item{expected_length}{An integer value, optional; is responsible to set a
size of text input field in content delivery engine.}

\item{placeholder}{A character string, optional; is responsible to place some
helpful text in text input field in content delivery engine.}
}
\value{
A character string mapped as yaml.
}
\description{
Create YAML string for NumericGap object
}
\examples{
gap_numeric(5.0, tolerance = 10, tolerance_type = "relative")

}
\seealso{
\code{\link[=gap_text]{gap_text()}}, \code{\link[=dropdown]{dropdown()}}, \code{\link[=mdlist]{mdlist()}}
}
