% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{antspynet_segmentation}
\alias{antspynet_segmentation}
\alias{antspynet_desikan_killiany_tourville_labeling}
\alias{antspynet_deep_atropos}
\title{Imaging segmentation using \code{antspynet}}
\usage{
antspynet_desikan_killiany_tourville_labeling(
  x,
  do_preprocessing = TRUE,
  return_probability_images = FALSE,
  do_lobar_parcellation = FALSE,
  verbose = TRUE
)

antspynet_deep_atropos(
  x,
  do_preprocessing = TRUE,
  use_spatial_priors = TRUE,
  aseg_only = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{\code{'NIfTI'} image or path to the image that is to be segmented}

\item{do_preprocessing}{whether \code{x} is in native space and needs the be
registered to template brain before performing segmentation; default is true
since the model is trained with template brain. If you want to manually
process the image, see \code{\link{antspynet_preprocess_brain_image}}}

\item{return_probability_images}{whether to return probability images}

\item{do_lobar_parcellation}{whether to perform lobar 'parcellation'}

\item{verbose}{whether to print out the messages}

\item{use_spatial_priors}{whether to use \code{'MNI'} partial tissue priors}

\item{aseg_only}{whether to just return the segmented image}
}
\value{
One or a list of \code{'ANTsImage'} image instances. Please print
out \code{antspynet$desikan_killiany_tourville_labeling} or
\code{antspynet$deep_atropos} to see the details.
}
\description{
Supports \code{Desikan-Killiany-Tourville} labeling and deep \code{'Atropos'}.
}
\examples{


# Print Python documents
if(interactive() && ants_available("antspynet")) {
  antspynet <- load_antspynet()

  print(antspynet$deep_atropos)

  print(antspynet$desikan_killiany_tourville_labeling)
}


}
\seealso{
\code{antspynet$desikan_killiany_tourville_labeling},
\code{antspynet$deep_atropos}
}
