% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutates.R
\name{update_tomic}
\alias{update_tomic}
\title{Update T* Omic}
\usage{
update_tomic(tomic, tomic_table)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{tomic_table}{A table taken from a tidy (i.e., augmented measurements)
or triple omic dataset}
}
\value{
A \code{tomic} object with updated features, samples or measurements.
}
\description{
Provide an updated features, samples or measurements table to a
  \code{tomic}.
}
\examples{

library(dplyr)
updated_features <- brauer_2008_triple$features \%>\%
  dplyr::filter(BP == "biological process unknown") \%>\%
  dplyr::mutate(chromosome = purrr::map_int(systematic_name, function(x) {
    which(LETTERS == stringr::str_match(x, "Y([A-Z])")[2])
  }))

update_tomic(brauer_2008_triple, updated_features)
}
