/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.lmt;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.lmt.ResidualSplit;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class ResidualModelSelection
extends ModelSelection {
    private static final long serialVersionUID = -293098783159385148L;
    protected int m_minNumInstances;
    protected double m_minInfoGain;

    public ResidualModelSelection(int minNumInstances) {
        this.m_minNumInstances = minNumInstances;
        this.m_minInfoGain = 1.0E-4;
    }

    public void cleanup() {
    }

    public final ClassifierSplitModel selectModel(Instances data, double[][] dataZs, double[][] dataWs) throws Exception {
        int numAttributes = data.numAttributes();
        if (numAttributes < 2) {
            throw new Exception("Can't select Model without non-class attribute");
        }
        if (data.numInstances() < this.m_minNumInstances) {
            return new NoSplit(new Distribution(data));
        }
        double bestGain = -1.7976931348623157E308;
        int bestAttribute = -1;
        int i = 0;
        while (i < numAttributes) {
            if (i != data.classIndex()) {
                double gain;
                ResidualSplit split = new ResidualSplit(i);
                split.buildClassifier(data, dataZs, dataWs);
                if (split.checkModel(this.m_minNumInstances) && (gain = split.entropyGain()) > bestGain) {
                    bestGain = gain;
                    bestAttribute = i;
                }
            }
            ++i;
        }
        if (bestGain >= this.m_minInfoGain) {
            ResidualSplit split = new ResidualSplit(bestAttribute);
            split.buildClassifier(data, dataZs, dataWs);
            return split;
        }
        return new NoSplit(new Distribution(data));
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances train) {
        return null;
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances train, Instances test) {
        return null;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

